/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.dmrclient;

import java.util.Map;
import org.hawkular.dmrclient.Address;
import org.hawkular.dmrclient.FailureException;
import org.hawkular.dmrclient.JBossASClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;

public class DatasourceJBossASClient
extends JBossASClient {
    public static final String SUBSYSTEM_DATASOURCES = "datasources";
    public static final String DATA_SOURCE = "data-source";
    public static final String XA_DATA_SOURCE = "xa-data-source";
    public static final String JDBC_DRIVER = "jdbc-driver";
    public static final String CONNECTION_PROPERTIES = "connection-properties";
    public static final String XA_DATASOURCE_PROPERTIES = "xa-datasource-properties";
    public static final String OP_ENABLE = "enable";
    public static final String DATASOURCE_PATH_PREFIX = "/subsystem=datasources/data-source=";
    public static final String XA_DATASOURCE_PATH_PREFIX = "/subsystem=datasources/xa-data-source=";
    public static final String JDBC_DRIVER_PATH_PREFIX = "/subsystem=datasources/jdbc-driver=";

    public static void checkDatasourcePath(String modelNodePath) {
        if (!modelNodePath.startsWith(DATASOURCE_PATH_PREFIX) && !modelNodePath.startsWith(XA_DATASOURCE_PATH_PREFIX)) {
            String msg = String.format("[%s] is not a datasource path. It must start with either [%s] or [%s]", modelNodePath, DATASOURCE_PATH_PREFIX, XA_DATASOURCE_PATH_PREFIX);
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkJdbcDriverPath(String modelNodePath) {
        if (!modelNodePath.startsWith(JDBC_DRIVER_PATH_PREFIX)) {
            String msg = String.format("[%s] is not a datasource path. It must start with [%s]", modelNodePath, JDBC_DRIVER_PATH_PREFIX);
            throw new IllegalArgumentException(msg);
        }
    }

    public DatasourceJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public void removeDatasource(String name) throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES);
        if (this.isDatasource(name)) {
            addr.add(DATA_SOURCE, name);
        } else if (this.isXADatasource(name)) {
            addr.add(XA_DATA_SOURCE, name);
        } else {
            return;
        }
        this.remove(addr);
    }

    public boolean isDatasourceEnabled(String name) throws Exception {
        return this.isDatasourceEnabled(false, name);
    }

    public boolean isXADatasourceEnabled(String name) throws Exception {
        return this.isDatasourceEnabled(true, name);
    }

    private boolean isDatasourceEnabled(boolean isXA, String name) throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES);
        addr.add(isXA ? XA_DATA_SOURCE : DATA_SOURCE, name);
        ModelNode results = this.readResource(addr);
        boolean enabledFlag = false;
        if (results.hasDefined("enabled")) {
            ModelNode enabled = results.get("enabled");
            enabledFlag = enabled.asBoolean(false);
        }
        return enabledFlag;
    }

    public void enableDatasource(String name) throws Exception {
        this.enableDatasource(false, name);
    }

    public void enableXADatasource(String name) throws Exception {
        this.enableDatasource(true, name);
    }

    private void enableDatasource(boolean isXA, String name) throws Exception {
        if (this.isDatasourceEnabled(isXA, name)) {
            return;
        }
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES);
        addr.add(isXA ? XA_DATA_SOURCE : DATA_SOURCE, name);
        ModelNode request = DatasourceJBossASClient.createRequest(OP_ENABLE, addr);
        request.get("persistent").set(true);
        ModelNode results = this.execute(request);
        if (!DatasourceJBossASClient.isSuccess(results)) {
            throw new FailureException(results);
        }
    }

    public boolean isJDBCDriver(String jdbcDriverName) throws Exception {
        String haystack;
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES);
        return null != this.findNodeInList(addr, haystack = JDBC_DRIVER, jdbcDriverName);
    }

    public boolean isDatasource(String datasourceName) throws Exception {
        String haystack;
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES);
        return null != this.findNodeInList(addr, haystack = DATA_SOURCE, datasourceName);
    }

    public boolean isXADatasource(String datasourceName) throws Exception {
        String haystack;
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES);
        return null != this.findNodeInList(addr, haystack = XA_DATA_SOURCE, datasourceName);
    }

    public ModelNode addJdbcDriver(String driverName, String moduleName, String driverClassName, Integer driverMajorVersion, Integer driverMinorVersion) throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, JDBC_DRIVER, driverName);
        ModelNode driverNode = new ModelNode();
        driverNode.get("driver-name").set(driverName);
        driverNode.get("driver-module-name").set(moduleName);
        if (driverClassName != null) {
            driverNode.get("driver-class-name").set(driverClassName);
        }
        if (driverMajorVersion != null) {
            driverNode.get("driver-major-version").set(driverMajorVersion);
        }
        if (driverMinorVersion != null) {
            driverNode.get("driver-minor-version").set(driverMinorVersion);
        }
        driverNode.get("operation").set("add");
        driverNode.get("address").set(addr.getAddressNode());
        return this.execute(driverNode);
    }

    public ModelNode addXaDatasource(String datasourceName, String jndiName, String driverName, String xaDataSourceClass, Map<String, String> xaDatasourceProperties, String userName, String password, String securityDomain) throws Exception {
        ModelNode batch;
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, XA_DATA_SOURCE, datasourceName);
        ModelNode dsNode = new ModelNode();
        dsNode.get("name").set(datasourceName);
        dsNode.get("jndi-name").set(jndiName);
        dsNode.get("driver-name").set(driverName);
        dsNode.get("xa-datasource-class").set(xaDataSourceClass);
        if (userName != null) {
            dsNode.get("user-name").set(userName);
        }
        if (password != null) {
            dsNode.get("password").set(password);
        }
        if (securityDomain != null) {
            dsNode.get("security-domain").set(securityDomain);
        }
        dsNode.get("operation").set("add");
        dsNode.get("address").set(addr.getAddressNode());
        if (xaDatasourceProperties == null || xaDatasourceProperties.isEmpty()) {
            batch = dsNode;
        } else {
            batch = new ModelNode();
            batch.get("operation").set("composite");
            batch.get("address").setEmptyList();
            ModelNode stepsNode = batch.get("steps");
            stepsNode.add(dsNode);
            for (Map.Entry<String, String> prop : xaDatasourceProperties.entrySet()) {
                addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, XA_DATA_SOURCE, datasourceName, XA_DATASOURCE_PROPERTIES, prop.getKey());
                ModelNode propNode = new ModelNode();
                propNode.get("operation").set("add");
                propNode.get("address").set(addr.getAddressNode());
                DatasourceJBossASClient.setPossibleExpression(propNode, "value", prop.getValue());
                stepsNode.add(propNode);
            }
        }
        return this.execute(batch);
    }

    public ModelNode addDatasource(String datasourceName, String jndiName, String driverName, String driverClass, String connectionUrl, Map<String, String> xaDatasourceProperties, String userName, String password) throws Exception {
        ModelNode batch;
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, DATA_SOURCE, datasourceName);
        ModelNode dsNode = new ModelNode();
        dsNode.get("name").set(datasourceName);
        dsNode.get("jndi-name").set(jndiName);
        dsNode.get("driver-name").set(driverName);
        dsNode.get("driver-class").set(driverClass);
        dsNode.get("connection-url").set(connectionUrl);
        if (userName != null) {
            dsNode.get("user-name").set(userName);
        }
        if (password != null) {
            dsNode.get("password").set(password);
        }
        dsNode.get("operation").set("add");
        dsNode.get("address").set(addr.getAddressNode());
        if (xaDatasourceProperties == null || xaDatasourceProperties.isEmpty()) {
            batch = dsNode;
        } else {
            batch = new ModelNode();
            batch.get("operation").set("composite");
            batch.get("address").setEmptyList();
            ModelNode stepsNode = batch.get("steps");
            stepsNode.add(dsNode);
            for (Map.Entry<String, String> prop : xaDatasourceProperties.entrySet()) {
                addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, DATA_SOURCE, datasourceName, CONNECTION_PROPERTIES, prop.getKey());
                ModelNode propNode = new ModelNode();
                propNode.get("operation").set("add");
                propNode.get("address").set(addr.getAddressNode());
                DatasourceJBossASClient.setPossibleExpression(propNode, "value", prop.getValue());
                stepsNode.add(propNode);
            }
        }
        return this.execute(batch);
    }

    public ModelNode createNewDatasourceRequest(String name, int blockingTimeoutWaitMillis, String connectionUrlExpression, String driverName, String exceptionSorterClassName, int idleTimeoutMinutes, boolean jta, int minPoolSize, int maxPoolSize, int preparedStatementCacheSize, String securityDomain, String staleConnectionCheckerClassName, String transactionIsolation, String validConnectionCheckerClassName, boolean validateOnMatch, Map<String, String> connectionProperties) {
        String jndiName = "java:jboss/datasources/" + name;
        String dmrTemplate = "{\"blocking-timeout-wait-millis\" => %dL , \"connection-url\" => expression \"%s\" , \"driver-name\" => \"%s\" , \"exception-sorter-class-name\" => \"%s\" , \"idle-timeout-minutes\" => %dL , \"jndi-name\" => \"%s\" , \"jta\" => %s , \"min-pool-size\" => %d , \"max-pool-size\" => %d , \"prepared-statements-cache-size\" => %dL , \"security-domain\" => \"%s\" , \"stale-connection-checker-class-name\" => \"%s\" , \"transaction-isolation\" => \"%s\" , \"use-java-context\" => true , \"valid-connection-checker-class-name\" => \"%s\" , \"validate-on-match\" => %s }";
        String dmr = String.format(dmrTemplate, blockingTimeoutWaitMillis, connectionUrlExpression, driverName, exceptionSorterClassName, idleTimeoutMinutes, jndiName, jta, minPoolSize, maxPoolSize, preparedStatementCacheSize, securityDomain, staleConnectionCheckerClassName, transactionIsolation, validConnectionCheckerClassName, validateOnMatch);
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, DATA_SOURCE, name);
        ModelNode request1 = ModelNode.fromString(dmr);
        request1.get("operation").set("add");
        request1.get("address").set(addr.getAddressNode());
        if (connectionProperties == null || connectionProperties.size() == 0) {
            return request1;
        }
        ModelNode[] batch = new ModelNode[1 + connectionProperties.size()];
        batch[0] = request1;
        int n = 1;
        for (Map.Entry<String, String> entry : connectionProperties.entrySet()) {
            addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, DATA_SOURCE, name, CONNECTION_PROPERTIES, entry.getKey());
            ModelNode requestN = new ModelNode();
            requestN.get("operation").set("add");
            requestN.get("address").set(addr.getAddressNode());
            DatasourceJBossASClient.setPossibleExpression(requestN, "value", entry.getValue());
            batch[n++] = requestN;
        }
        return DatasourceJBossASClient.createBatchRequest(batch);
    }

    public ModelNode createNewDatasourceRequest(String name, String connectionUrlExpression, String driverName, boolean jta, Map<String, String> connectionProperties) {
        String jndiName = "java:jboss/datasources/" + name;
        String dmrTemplate = "{\"connection-url\" => expression \"%s\" , \"driver-name\" => \"%s\" , \"jndi-name\" => \"%s\" , \"jta\" => %s , \"use-java-context\" => true }";
        String dmr = String.format(dmrTemplate, connectionUrlExpression, driverName, jndiName, jta);
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, DATA_SOURCE, name);
        ModelNode request1 = ModelNode.fromString(dmr);
        request1.get("operation").set("add");
        request1.get("address").set(addr.getAddressNode());
        if (connectionProperties == null || connectionProperties.size() == 0) {
            return request1;
        }
        ModelNode[] batch = new ModelNode[1 + connectionProperties.size()];
        batch[0] = request1;
        int n = 1;
        for (Map.Entry<String, String> entry : connectionProperties.entrySet()) {
            addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, DATA_SOURCE, name, CONNECTION_PROPERTIES, entry.getKey());
            ModelNode requestN = new ModelNode();
            requestN.get("operation").set("add");
            requestN.get("address").set(addr.getAddressNode());
            if (entry.getValue().indexOf("${") > -1) {
                requestN.get("value").set(new ValueExpression(entry.getValue()));
            } else {
                requestN.get("value").set(entry.getValue());
            }
            batch[n++] = requestN;
        }
        return DatasourceJBossASClient.createBatchRequest(batch);
    }

    public ModelNode createNewXADatasourceRequest(String name, int blockingTimeoutWaitMillis, String driverName, String xaDataSourceClass, String exceptionSorterClassName, int idleTimeoutMinutes, int minPoolSize, int maxPoolSize, Boolean noRecovery, Boolean noTxSeparatePool, int preparedStatementCacheSize, String recoveryPluginClassName, String securityDomain, String staleConnectionCheckerClassName, String transactionIsolation, String validConnectionCheckerClassName, Map<String, String> xaDatasourceProperties) {
        String jndiName = "java:jboss/datasources/" + name;
        String dmrTemplate = "{\"xa-datasource-class\" => \"%s\", \"blocking-timeout-wait-millis\" => %dL , \"driver-name\" => \"%s\" , \"exception-sorter-class-name\" => \"%s\" , \"idle-timeout-minutes\" => %dL , \"jndi-name\" => \"%s\" , \"jta\" => true , \"min-pool-size\" => %d , \"max-pool-size\" => %d , \"no-recovery\" => %b , \"no-tx-separate-pool\" => %b , \"prepared-statements-cache-size\" => %dL , \"recovery-plugin-class-name\" => \"%s\" , \"security-domain\" => \"%s\" , \"stale-connection-checker-class-name\" => \"%s\" , \"transaction-isolation\" => \"%s\" , \"use-java-context\" => true , \"valid-connection-checker-class-name\" => \"%s\" }";
        String dmr = String.format(dmrTemplate, xaDataSourceClass, blockingTimeoutWaitMillis, driverName, exceptionSorterClassName, idleTimeoutMinutes, jndiName, minPoolSize, maxPoolSize, noRecovery, noTxSeparatePool, preparedStatementCacheSize, recoveryPluginClassName, securityDomain, staleConnectionCheckerClassName, transactionIsolation, validConnectionCheckerClassName);
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, XA_DATA_SOURCE, name);
        ModelNode request1 = ModelNode.fromString(dmr);
        request1.get("operation").set("add");
        request1.get("address").set(addr.getAddressNode());
        if (xaDatasourceProperties == null || xaDatasourceProperties.size() == 0) {
            return request1;
        }
        ModelNode[] batch = new ModelNode[1 + xaDatasourceProperties.size()];
        batch[0] = request1;
        int n = 1;
        for (Map.Entry<String, String> entry : xaDatasourceProperties.entrySet()) {
            addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, XA_DATA_SOURCE, name, XA_DATASOURCE_PROPERTIES, entry.getKey());
            ModelNode requestN = new ModelNode();
            requestN.get("operation").set("add");
            requestN.get("address").set(addr.getAddressNode());
            DatasourceJBossASClient.setPossibleExpression(requestN, "value", entry.getValue());
            batch[n++] = requestN;
        }
        ModelNode result = DatasourceJBossASClient.createBatchRequest(batch);
        if (null == noRecovery) {
            result.get("steps").get(0).remove("no-recovery");
        }
        if (null == noTxSeparatePool) {
            result.get("steps").get(0).remove("no-tx-separate-pool");
        }
        if (null == recoveryPluginClassName) {
            result.get("steps").get(0).remove("recovery-plugin-class-name");
        }
        if (null == staleConnectionCheckerClassName) {
            result.get("steps").get(0).remove("stale-connection-checker-class-name");
        }
        return result;
    }
}

