/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.dmrclient;

import org.hawkular.dmrclient.JBossASClient;
import org.jboss.dmr.ModelNode;

public class FailureException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final String GENERIC_ERROR = "Failed request";

    public FailureException(ModelNode failureNode) {
        super(FailureException.buildErrorMessage(GENERIC_ERROR, failureNode));
    }

    public FailureException(ModelNode failureNode, String errMsg) {
        super(FailureException.buildErrorMessage(errMsg, failureNode));
    }

    public FailureException(ModelNode failureNode, Throwable cause) {
        super(FailureException.buildErrorMessage(GENERIC_ERROR, failureNode), cause);
    }

    public FailureException(ModelNode failureNode, String errMsg, Throwable cause) {
        super(FailureException.buildErrorMessage(errMsg, failureNode), cause);
    }

    public FailureException(String errMsg, Throwable cause) {
        super(errMsg != null ? errMsg : GENERIC_ERROR, cause);
    }

    public FailureException(String errMsg) {
        super(errMsg != null ? errMsg : GENERIC_ERROR);
    }

    public FailureException(Throwable cause) {
        super(GENERIC_ERROR, cause);
    }

    public FailureException() {
        super(GENERIC_ERROR);
    }

    private static String buildErrorMessage(String errMsg, ModelNode failureNode) {
        String description;
        if (errMsg == null) {
            errMsg = GENERIC_ERROR;
        }
        if ((description = JBossASClient.getFailureDescription(failureNode)) != null) {
            errMsg = errMsg + ": " + description;
        }
        return errMsg;
    }
}

