/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hawkular.inventory.api.model.AbstractHashTree;
import org.hawkular.inventory.api.model.ComputeHash;
import org.hawkular.inventory.api.model.Hashes;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;

public final class SyncHash {
    private SyncHash() {
    }

    public static String of(InventoryStructure<?> structure, CanonicalPath rootPath) {
        return ComputeHash.of(structure, rootPath, true, true, true).getSyncHash();
    }

    public static Tree treeOf(InventoryStructure<?> structure, CanonicalPath rootPath, Function<RelativePath, Hashes> hashLoader) {
        Tree.AbstractBuilder[] tbld = new Tree.AbstractBuilder[1];
        Consumer<ComputeHash.IntermediateHashContext> startChild = context -> {
            tbld[0] = tbld[0] == null ? Tree.builder() : (Tree.AbstractBuilder)tbld[0].startChild();
        };
        BiConsumer<ComputeHash.IntermediateHashContext, ComputeHash.IntermediateHashResult> endChild = (ctx, result) -> {
            if (tbld[0] instanceof Tree.ChildBuilder) {
                tbld[0].withHash(result.syncHash).withPath(result.path);
                Tree.AbstractBuilder parent = (Tree.AbstractBuilder)((Tree.ChildBuilder)tbld[0]).getParent();
                parent.addChild(((Tree.ChildBuilder)tbld[0]).build());
                tbld[0] = parent;
            }
        };
        ComputeHash.IntermediateHashResult res = ComputeHash.treeOf(structure, rootPath, true, true, true, startChild, endChild, hashLoader);
        tbld[0].withPath(res.path).withHash((String)res.syncHash);
        return ((Tree.Builder)tbld[0]).build();
    }

    public static Tree treeOf(InventoryStructure<?> structure, CanonicalPath rootPath) {
        return SyncHash.treeOf(structure, rootPath, p -> null);
    }

    public static final class Tree
    extends AbstractHashTree<Tree, String> {
        private Tree() {
            this(null, null, null);
        }

        private Tree(RelativePath path, String hash, Map<Path.Segment, Tree> children) {
            super(path, hash, children);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class ChildBuilder<Parent extends AbstractHashTree.Builder<Parent, ChildBuilder<Parent>, Tree, String> & AbstractBuilder<Parent>>
        extends AbstractHashTree.AbstractChildBuilder<ChildBuilder<Parent>, Parent, ChildBuilder<ChildBuilder<Parent>>, Tree, String>
        implements AbstractBuilder<ChildBuilder<Parent>>,
        AbstractHashTree.ChildBuilder<ChildBuilder<Parent>, Parent, ChildBuilder<ChildBuilder<Parent>>, Tree, String> {
            ChildBuilder(AbstractHashTree.TreeConstructor<Tree, String> tctor, Parent p) {
                super(tctor, p, ChildBuilder::new);
            }
        }

        public static final class Builder
        extends AbstractHashTree.AbstractBuilder<Builder, ChildBuilder<Builder>, Tree, String>
        implements AbstractBuilder<Builder>,
        AbstractHashTree.TopBuilder<Builder, ChildBuilder<Builder>, Tree, String> {
            private Builder() {
                super((x$0, x$1, x$2) -> new Tree(x$0, (String)((Object)x$1), x$2), ChildBuilder::new);
            }

            @Override
            public Tree build() {
                return (Tree)super.build();
            }
        }

        public static interface AbstractBuilder<This extends AbstractHashTree.Builder<This, ChildBuilder<This>, Tree, String> & AbstractBuilder<This>>
        extends AbstractHashTree.Builder<This, ChildBuilder<This>, Tree, String> {
        }
    }
}

