/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.util.Map;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Syncable;
import org.hawkular.inventory.paths.CanonicalPath;

@ApiModel(description="A super type of all entities that support identity hashing", subTypes={Feed.class, MetricType.class, Metric.class, Resource.class, DataEntity.class, OperationType.class, ResourceType.class}, parent=Entity.class)
public abstract class SyncedEntity<B extends Entity.Blueprint, U extends Entity.Update>
extends Entity<B, U>
implements Syncable {
    private final String identityHash;
    private final String contentHash;
    private final String syncHash;

    SyncedEntity() {
        this.identityHash = null;
        this.contentHash = null;
        this.syncHash = null;
    }

    SyncedEntity(String name, CanonicalPath path, String identityHash, String contentHash, String syncHash) {
        super(name, path);
        this.identityHash = identityHash;
        this.contentHash = contentHash;
        this.syncHash = syncHash;
    }

    SyncedEntity(String name, CanonicalPath path, String identityHash, String contentHash, String syncHash, Map<String, Object> properties) {
        super(name, path, properties);
        this.identityHash = identityHash;
        this.contentHash = contentHash;
        this.syncHash = syncHash;
    }

    SyncedEntity(CanonicalPath path, String identityHash, String contentHash, String syncHash) {
        super(path);
        this.identityHash = identityHash;
        this.contentHash = contentHash;
        this.syncHash = syncHash;
    }

    SyncedEntity(CanonicalPath path, String identityHash, String contentHash, String syncHash, Map<String, Object> properties) {
        super(path, properties);
        this.identityHash = identityHash;
        this.contentHash = contentHash;
        this.syncHash = syncHash;
    }

    @Override
    public String getIdentityHash() {
        return this.identityHash;
    }

    @Override
    public String getContentHash() {
        return this.contentHash;
    }

    @Override
    public String getSyncHash() {
        return this.syncHash;
    }
}

