/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.json.NullAwareJsonObjectBuilder;
import oshi.json.OshiJsonObject;

public class NetworkIF
implements OshiJsonObject {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(NetworkIF.class);
    private JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    private NetworkInterface networkInterface;
    private int mtu;
    private String mac;
    private String[] ipv4;
    private String[] ipv6;
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long speed;

    public NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    public void setNetworkInterface(NetworkInterface networkInterface) {
        this.networkInterface = networkInterface;
        try {
            this.mtu = networkInterface.getMTU();
            StringBuilder sb = new StringBuilder(18);
            byte[] mac = networkInterface.getHardwareAddress();
            if (mac != null) {
                for (byte b : mac) {
                    if (sb.length() > 0) {
                        sb.append(':');
                    }
                    sb.append(String.format("%02x", b));
                }
            } else {
                this.mac = "Unknown";
            }
            this.mac = sb.toString();
            ArrayList<String> ipv4list = new ArrayList<String>();
            ArrayList<String> ipv6list = new ArrayList<String>();
            for (InetAddress address : Collections.list(networkInterface.getInetAddresses())) {
                if (address.getHostAddress().length() == 0) continue;
                if (address.getHostAddress().contains(":")) {
                    ipv6list.add(address.getHostAddress().split("%")[0]);
                    continue;
                }
                ipv4list.add(address.getHostAddress());
            }
            this.ipv4 = ipv4list.toArray(new String[ipv4list.size()]);
            this.ipv6 = ipv6list.toArray(new String[ipv6list.size()]);
        }
        catch (SocketException e) {
            LOG.error("Socket exception: {}", e);
            return;
        }
    }

    public String getName() {
        return this.networkInterface.getName();
    }

    public String getDisplayName() {
        return this.networkInterface.getDisplayName();
    }

    public int getMTU() {
        return this.mtu;
    }

    public String getMacaddr() {
        return this.mac;
    }

    public String[] getIPv4addr() {
        return Arrays.copyOf(this.ipv4, this.ipv4.length);
    }

    public String[] getIPv6addr() {
        return Arrays.copyOf(this.ipv6, this.ipv6.length);
    }

    public long getBytesRecv() {
        return this.bytesRecv;
    }

    public void setBytesRecv(long bytesRecv) {
        this.bytesRecv = bytesRecv;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(long bytesSent) {
        this.bytesSent = bytesSent;
    }

    public long getPacketsRecv() {
        return this.packetsRecv;
    }

    public void setPacketsRecv(long packetsRecv) {
        this.packetsRecv = packetsRecv;
    }

    public long getPacketsSent() {
        return this.packetsSent;
    }

    public void setPacketsSent(long packetsSent) {
        this.packetsSent = packetsSent;
    }

    public long getSpeed() {
        return this.speed;
    }

    public void setSpeed(long speed) {
        this.speed = speed;
    }

    @Override
    public JsonObject toJSON() {
        JsonArrayBuilder ipv4ArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (String ipv4 : this.getIPv4addr()) {
            ipv4ArrayBuilder.add(ipv4);
        }
        JsonArrayBuilder ipv6ArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (String ipv4 : this.getIPv6addr()) {
            ipv6ArrayBuilder.add(ipv4);
        }
        return NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder()).add("name", this.getName()).add("displayName", this.getDisplayName()).add("mac", this.getMacaddr()).add("ipv4", ipv4ArrayBuilder.build()).add("ipv6", ipv6ArrayBuilder.build()).add("mtu", this.getMTU()).add("bytesRecv", this.getBytesRecv()).add("bytesSent", this.getBytesSent()).add("packetsRecv", this.getPacketsRecv()).add("packetsSent", this.getPacketsSent()).add("speed", this.getSpeed()).build();
    }
}

