/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.mac.CoreFoundation;
import oshi.jna.platform.mac.IOKit;
import oshi.jna.platform.mac.SystemB;
import oshi.software.common.AbstractFileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.platform.mac.IOKitUtil;
import oshi.util.platform.mac.SysctlUtil;

public class MacFileSystem
extends AbstractFileSystem {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MacFileSystem.class);
    private static final Pattern LOCAL_DISK = Pattern.compile("/dev/disk\\d");

    @Override
    public OSFileStore[] getFileStores() {
        HashMap<String, String> fstype = new HashMap<String, String>();
        int numfs = SystemB.INSTANCE.getfsstat64(null, 0, 0);
        if (numfs > 0) {
            SystemB.Statfs[] fs = new SystemB.Statfs[numfs];
            numfs = SystemB.INSTANCE.getfsstat64(fs, numfs * new SystemB.Statfs().size(), 16);
            for (int f = 0; f < numfs; ++f) {
                fstype.put(new String(fs[f].f_mntonname).trim(), new String(fs[f].f_fstypename).trim());
            }
        }
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        FileSystemView fsv = FileSystemView.getFileSystemView();
        File volumes = new File("/Volumes");
        if (volumes != null && volumes.listFiles() != null) {
            for (File f : volumes.listFiles()) {
                String uuid;
                String volume;
                String path;
                String type;
                String description;
                String name;
                block12: {
                    if (f.getName().endsWith(".DS_Store")) continue;
                    name = fsv.getSystemDisplayName(f);
                    description = "Volume";
                    type = "unknown";
                    path = "unknown";
                    volume = "";
                    uuid = "";
                    try {
                        CoreFoundation.CFMutableDictionaryRef matchingDict;
                        String bsdName;
                        FileStore fs;
                        path = f.getCanonicalPath();
                        if (path.equals("/")) {
                            name = name + " (/)";
                        }
                        if (LOCAL_DISK.matcher(volume = (fs = Files.getFileStore(f.toPath())).name()).matches()) {
                            description = "Local Disk";
                        }
                        if (volume.startsWith("localhost:") || volume.startsWith("//")) {
                            description = "Network Drive";
                        }
                        if (fstype.containsKey(path)) {
                            type = (String)fstype.get(path);
                        }
                        if (!(bsdName = volume.replace("/dev/disk", "disk")).startsWith("disk") || (matchingDict = IOKitUtil.getBSDNameMatchingDict(bsdName)) == null) break block12;
                        IntByReference fsIter = new IntByReference();
                        IOKitUtil.getMatchingServices(matchingDict, fsIter);
                        int fsEntry = IOKit.INSTANCE.IOIteratorNext(fsIter.getValue());
                        if (fsEntry != 0 && IOKit.INSTANCE.IOObjectConformsTo(fsEntry, "IOMedia")) {
                            uuid = IOKitUtil.getIORegistryStringProperty(fsEntry, "UUID");
                            if (uuid == null) {
                                uuid = "";
                            }
                            IOKit.INSTANCE.IOObjectRelease(fsEntry);
                        }
                        IOKit.INSTANCE.IOObjectRelease(fsIter.getValue());
                    }
                    catch (IOException e) {
                        LOG.trace("", e);
                        continue;
                    }
                }
                fsList.add(new OSFileStore(name, volume, path, description, type, uuid, f.getUsableSpace(), f.getTotalSpace()));
            }
        }
        return fsList.toArray(new OSFileStore[fsList.size()]);
    }

    @Override
    public long getOpenFileDescriptors() {
        return SysctlUtil.sysctl("kern.num_files", 0);
    }

    @Override
    public long getMaxFileDescriptors() {
        return SysctlUtil.sysctl("kern.maxfiles", 0);
    }
}

