/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public final class JsonNumEquals
extends Equivalence<JsonNode> {
    private static final Equivalence<JsonNode> INSTANCE = new JsonNumEquals();

    private JsonNumEquals() {
    }

    public static Equivalence<JsonNode> getInstance() {
        return INSTANCE;
    }

    protected boolean doEquivalent(JsonNode a, JsonNode b) {
        NodeType typeB;
        if (a.isNumber() && b.isNumber()) {
            return JsonNumEquals.numEquals(a, b);
        }
        NodeType typeA = NodeType.getNodeType(a);
        if (typeA != (typeB = NodeType.getNodeType(b))) {
            return false;
        }
        if (!a.isContainerNode()) {
            return a.equals(b);
        }
        if (a.size() != b.size()) {
            return false;
        }
        return typeA == NodeType.ARRAY ? this.arrayEquals(a, b) : this.objectEquals(a, b);
    }

    protected int doHash(JsonNode t) {
        if (t.isNumber()) {
            return Double.valueOf(t.doubleValue()).hashCode();
        }
        if (!t.isContainerNode()) {
            return t.hashCode();
        }
        int ret = 0;
        if (t.size() == 0) {
            return ret;
        }
        if (t.isArray()) {
            for (JsonNode element : t) {
                ret = 31 * ret + this.doHash(element);
            }
            return ret;
        }
        Iterator<Map.Entry<String, JsonNode>> iterator = t.fields();
        while (iterator.hasNext()) {
            Map.Entry<String, JsonNode> entry = iterator.next();
            ret = 31 * ret + (entry.getKey().hashCode() ^ this.doHash(entry.getValue()));
        }
        return ret;
    }

    private static boolean numEquals(JsonNode a, JsonNode b) {
        if (a.isIntegralNumber() && b.isIntegralNumber()) {
            return a.equals(b);
        }
        return a.decimalValue().compareTo(b.decimalValue()) == 0;
    }

    private boolean arrayEquals(JsonNode a, JsonNode b) {
        int size = a.size();
        for (int i = 0; i < size; ++i) {
            if (this.doEquivalent(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean objectEquals(JsonNode a, JsonNode b) {
        HashSet keys = Sets.newHashSet(a.fieldNames());
        HashSet set = Sets.newHashSet(b.fieldNames());
        if (!((Object)set).equals(keys)) {
            return false;
        }
        for (String key : keys) {
            if (this.doEquivalent(a.get(key), b.get(key))) continue;
            return false;
        }
        return true;
    }
}

