/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.draftv3;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;

public final class PhoneAttribute
extends AbstractFormatAttribute {
    private static final PhoneNumberUtil PARSER = PhoneNumberUtil.getInstance();
    private static final FormatAttribute INSTANCE = new PhoneAttribute();

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private PhoneAttribute() {
        super("phone", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, MessageBundle bundle2, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        try {
            if (input.startsWith("+")) {
                PARSER.parse(input, "ZZ");
            } else {
                PARSER.parse(input, "FR");
            }
        }
        catch (NumberParseException ignored) {
            report.error(this.newMsg(data, bundle2, "err.format.invalidPhoneNumber").putArgument("value", input));
        }
    }
}

