/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.util.Dictionary;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.messages.JsonSchemaValidationBundle;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.processors.data.SchemaContext;
import com.github.fge.jsonschema.processors.data.ValidatorList;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;

public final class FormatProcessor
implements Processor<ValidatorList, ValidatorList> {
    private final Map<String, FormatAttribute> attributes;
    private final MessageBundle bundle;

    public FormatProcessor(Library library, ValidationConfiguration cfg) {
        this.attributes = library.getFormatAttributes().entries();
        this.bundle = cfg.getValidationMessages();
    }

    @VisibleForTesting
    FormatProcessor(Dictionary<FormatAttribute> dict) {
        this.attributes = dict.entries();
        this.bundle = MessageBundles.getBundle(JsonSchemaValidationBundle.class);
    }

    @Override
    public ValidatorList process(ProcessingReport report, ValidatorList input) throws ProcessingException {
        SchemaContext context = input.getContext();
        JsonNode node = context.getSchema().getNode().get("format");
        if (node == null) {
            return input;
        }
        String fmt = node.textValue();
        FormatAttribute attr = this.attributes.get(fmt);
        if (attr == null) {
            report.warn(input.newMessage().put("domain", "validation").put("keyword", "format").setMessage(this.bundle.getMessage("warn.format.notSupported")).putArgument("attribute", fmt));
            return input;
        }
        NodeType type = context.getInstanceType();
        if (!attr.supportedTypes().contains((Object)type)) {
            return input;
        }
        ArrayList validators = Lists.newArrayList((Iterable)input);
        validators.add(FormatProcessor.formatValidator(attr));
        return new ValidatorList(context, validators);
    }

    private static KeywordValidator formatValidator(final FormatAttribute attr) {
        return new KeywordValidator(){

            @Override
            public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle2, FullData data) throws ProcessingException {
                attr.validate(report, bundle2, data);
            }
        };
    }

    public String toString() {
        return "format attribute handler";
    }
}

