/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.keyword.syntax.SyntaxProcessor;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.processing.ProcessingResult;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.processing.ProcessorMap;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.core.report.DevNullProcessingReport;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.CanonicalSchemaTree;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.tree.key.SchemaKey;
import com.github.fge.jsonschema.core.util.Dictionary;
import com.github.fge.jsonschema.core.util.ValueHolder;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.base.Function;
import java.util.Map;

public final class SyntaxValidator {
    private static final Function<ValueHolder<SchemaTree>, JsonRef> FUNCTION = new Function<ValueHolder<SchemaTree>, JsonRef>(){

        public JsonRef apply(ValueHolder<SchemaTree> input) {
            return input.getValue().getDollarSchema();
        }
    };
    private final Processor<ValueHolder<SchemaTree>, ValueHolder<SchemaTree>> processor;

    public SyntaxValidator(ValidationConfiguration cfg) {
        MessageBundle syntaxMessages = cfg.getSyntaxMessages();
        ProcessorMap<JsonRef, ValueHolder<SchemaTree>, ValueHolder<SchemaTree>> map = new ProcessorMap<JsonRef, ValueHolder<SchemaTree>, ValueHolder<SchemaTree>>(FUNCTION);
        Dictionary<SyntaxChecker> dict = cfg.getDefaultLibrary().getSyntaxCheckers();
        SyntaxProcessor byDefault = new SyntaxProcessor(cfg.getSyntaxMessages(), dict);
        map.setDefaultProcessor(byDefault);
        Map<JsonRef, Library> libraries = cfg.getLibraries();
        for (Map.Entry<JsonRef, Library> entry : libraries.entrySet()) {
            JsonRef ref = entry.getKey();
            dict = entry.getValue().getSyntaxCheckers();
            SyntaxProcessor syntaxProcessor = new SyntaxProcessor(syntaxMessages, dict);
            map.addEntry(ref, syntaxProcessor);
        }
        this.processor = map.getProcessor();
    }

    public boolean schemaIsValid(JsonNode schema) {
        DevNullProcessingReport report = new DevNullProcessingReport();
        return this.getResult(schema, report).isSuccess();
    }

    public ProcessingReport validateSchema(JsonNode schema) {
        ListProcessingReport report = new ListProcessingReport();
        return this.getResult(schema, report).getReport();
    }

    public Processor<ValueHolder<SchemaTree>, ValueHolder<SchemaTree>> getProcessor() {
        return this.processor;
    }

    private ProcessingResult<ValueHolder<SchemaTree>> getResult(JsonNode schema, ProcessingReport report) {
        ValueHolder<SchemaTree> holder = SyntaxValidator.holder(schema);
        return ProcessingResult.uncheckedResult(this.processor, report, holder);
    }

    private static ValueHolder<SchemaTree> holder(JsonNode node) {
        return ValueHolder.hold("schema", new CanonicalSchemaTree(SchemaKey.anonymousKey(), node));
    }
}

