/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hawkular.agent.javaagent.config.Configuration;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;

public class ConfigManager {
    private static final MsgLogger log = AgentLoggers.getLogger(ConfigManager.class);
    private final File configFile;
    private final ReadWriteLock configurationLock = new ReentrantReadWriteLock(true);
    private Configuration configuration;

    public ConfigManager(File file) {
        this.configFile = file;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public boolean hasConfiguration() {
        Lock lock = this.configurationLock.readLock();
        lock.lock();
        try {
            boolean bl = this.configuration != null;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public Configuration getConfiguration() {
        Lock lock = this.configurationLock.readLock();
        lock.lock();
        try {
            Configuration configuration = this.configuration == null ? null : new Configuration(this.configuration);
            return configuration;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfiguration(boolean forceLoad) throws Exception {
        Lock lock = this.configurationLock.writeLock();
        lock.lock();
        try {
            if (this.configuration == null || forceLoad) {
                Configuration newConfig = this.load(this.configFile);
                newConfig.validate();
                this.configuration = newConfig;
            }
            Configuration configuration = new Configuration(this.configuration);
            return configuration;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfiguration(Configuration config, boolean createBackup) throws Exception {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        Lock lock = this.configurationLock.writeLock();
        lock.lock();
        try {
            this.save(this.configFile, config, createBackup);
            this.configuration = new Configuration(config);
        }
        finally {
            lock.unlock();
        }
    }

    private void save(File file, Configuration config, boolean createBackup) throws Exception {
        if (createBackup) {
            this.backup(file);
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        if (!file.canWrite()) {
            throw new FileNotFoundException("Config file [" + file + "] cannot be created or is not writable");
        }
        ObjectMapper mapper = this.createObjectMapper();
        mapper.writeValue(file, (Object)config);
    }

    private Configuration load(File file) throws Exception {
        if (!file.canRead()) {
            throw new FileNotFoundException("Config file [" + file + "] does not exist or cannot be read");
        }
        ObjectMapper mapper = this.createObjectMapper();
        Configuration config = mapper.readValue(file, Configuration.class);
        return config;
    }

    private void backup(File file) {
        if (file.canRead()) {
            Path source = file.toPath();
            Path destination = new File(file.getAbsolutePath() + ".bak").toPath();
            try {
                Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                log.debugf((Throwable)e, "Cannot backup config file [%s]", (Object)file);
            }
        }
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        return mapper;
    }
}

