/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.DMROperationParam;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class DMROperation
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty
    private String path = "/";
    @JsonProperty(value="internal-name")
    private String internalName;
    @JsonProperty
    private Boolean modifies = Boolean.FALSE;
    @JsonProperty(value="params")
    private DMROperationParam[] dmrOperationParams;

    public DMROperation() {
    }

    public DMROperation(DMROperation original) {
        this.name = original.name;
        this.path = original.path;
        this.internalName = original.internalName;
        this.modifies = original.modifies;
        this.dmrOperationParams = Util.cloneArray(original.dmrOperationParams);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("operation-dmr name must be specified");
        }
        try {
            if (!"/".equals(this.path)) {
                WildflyCompatibilityUtils.parseCLIStyleAddress(this.path);
            }
        }
        catch (Exception e) {
            throw new Exception("operation-dmr [" + this.name + "] path [" + this.path + "] is invalid", e);
        }
        if (this.dmrOperationParams != null) {
            for (DMROperationParam o : this.dmrOperationParams) {
                o.validate();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public Boolean getModifies() {
        return this.modifies;
    }

    public void setModifies(Boolean modifies) {
        this.modifies = modifies;
    }

    public DMROperationParam[] getDmrOperationParams() {
        return this.dmrOperationParams;
    }

    public void setDmrOperationParams(DMROperationParam[] dmrOperationParams) {
        this.dmrOperationParams = dmrOperationParams;
    }
}

