/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class DMRResourceConfig
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty
    private String path = "/";
    @JsonProperty(required=true)
    private String attribute;
    @JsonProperty(value="resolve-expressions")
    private Boolean resolveExpressions = Boolean.FALSE;
    @JsonProperty(value="include-defaults")
    private Boolean includeDefaults = Boolean.TRUE;

    public DMRResourceConfig() {
    }

    public DMRResourceConfig(DMRResourceConfig original) {
        this.name = original.name;
        this.path = original.path;
        this.attribute = original.attribute;
        this.resolveExpressions = original.resolveExpressions;
        this.includeDefaults = original.includeDefaults;
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("resource-config-dmr name must be specified");
        }
        if (this.attribute == null) {
            throw new Exception("resource-config-dmr [" + this.name + "] attribute must be specified");
        }
        try {
            if (!"/".equals(this.path)) {
                WildflyCompatibilityUtils.parseCLIStyleAddress(this.path);
            }
        }
        catch (Exception e) {
            throw new Exception("resource-config-dmr [" + this.name + "] path [" + this.path + "] is invalid", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public Boolean getResolveExpressions() {
        return this.resolveExpressions;
    }

    public void setResolveExpressions(Boolean resolveExpressions) {
        this.resolveExpressions = resolveExpressions;
    }

    public Boolean getIncludeDefaults() {
        return this.includeDefaults;
    }

    public void setIncludeDefaults(Boolean includeDefaults) {
        this.includeDefaults = includeDefaults;
    }
}

