/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.agent.javaagent.config.BooleanExpression;
import org.hawkular.agent.javaagent.config.StringExpression;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.agent.monitor.api.Avail;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class RemoteJMX
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty
    private BooleanExpression enabled = new BooleanExpression(Boolean.TRUE);
    @JsonProperty(required=true)
    private StringExpression url;
    @JsonProperty
    private StringExpression username;
    @JsonProperty
    private StringExpression password;
    @JsonProperty(value="security-realm")
    private String securityRealmName;
    @JsonProperty(value="tenant-id")
    private StringExpression tenantId;
    @JsonProperty(value="resource-type-sets")
    private String[] resourceTypeSets;
    @JsonProperty(value="metric-id-template")
    private String metricIdTemplate;
    @JsonProperty(value="metric-tags")
    private Map<String, String> metricTags;
    @JsonProperty(value="set-avail-on-shutdown")
    private Avail setAvailOnShutdown;

    public RemoteJMX() {
    }

    public RemoteJMX(RemoteJMX original) {
        this.name = original.name;
        this.enabled = original.enabled == null ? null : new BooleanExpression(original.enabled);
        this.url = original.url == null ? null : new StringExpression(original.url);
        this.username = original.username == null ? null : new StringExpression(original.username);
        this.password = original.password == null ? null : new StringExpression(original.password);
        this.securityRealmName = original.securityRealmName;
        this.tenantId = original.tenantId == null ? null : new StringExpression(original.tenantId);
        this.resourceTypeSets = original.resourceTypeSets == null ? null : Arrays.copyOf(original.resourceTypeSets, original.resourceTypeSets.length);
        this.metricIdTemplate = original.metricIdTemplate;
        this.metricTags = original.metricTags == null ? null : new HashMap<String, String>(original.metricTags);
        this.setAvailOnShutdown = original.setAvailOnShutdown;
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("remote-jmx name must be specified");
        }
        if (this.url == null || ((StringExpression.StringValue)this.url.get()).toString().trim().isEmpty()) {
            throw new Exception("remote-jmx url must be specified");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEnabled() {
        return this.enabled == null ? null : (Boolean)this.enabled.get();
    }

    public void setEnabled(Boolean enabled) {
        if (this.enabled != null) {
            this.enabled.set(enabled);
        } else {
            this.enabled = new BooleanExpression(enabled);
        }
    }

    public String getUrl() {
        return this.url == null ? null : ((StringExpression.StringValue)this.url.get()).toString();
    }

    public void setUrl(String url) {
        if (this.url != null) {
            this.url.set(new StringExpression.StringValue(url));
        } else {
            this.url = new StringExpression(new StringExpression.StringValue(url));
        }
    }

    public String getUsername() {
        return this.username == null ? null : ((StringExpression.StringValue)this.username.get()).toString();
    }

    public void setUsername(String username) {
        if (this.username != null) {
            this.username.set(new StringExpression.StringValue(username));
        } else {
            this.username = new StringExpression(new StringExpression.StringValue(username));
        }
    }

    public String getPassword() {
        return this.password == null ? null : ((StringExpression.StringValue)this.password.get()).toString();
    }

    public void setPassword(String password) {
        if (this.password != null) {
            this.password.set(new StringExpression.StringValue(password));
        } else {
            this.password = new StringExpression(new StringExpression.StringValue(password));
        }
    }

    public String getSecurityRealmName() {
        return this.securityRealmName;
    }

    public void setSecurityRealmName(String securityRealmName) {
        this.securityRealmName = securityRealmName;
    }

    public String getTenantId() {
        return this.tenantId == null ? null : ((StringExpression.StringValue)this.tenantId.get()).toString();
    }

    public void setTenantId(String tenantId) {
        if (this.tenantId != null) {
            this.tenantId.set(new StringExpression.StringValue(tenantId));
        } else {
            this.tenantId = new StringExpression(tenantId);
        }
    }

    public String[] getResourceTypeSets() {
        return this.resourceTypeSets;
    }

    public void setResourceTypeSets(String[] resourceTypeSets) {
        this.resourceTypeSets = resourceTypeSets;
    }

    public String getMetricIdTemplate() {
        return this.metricIdTemplate;
    }

    public void setMetricIdTemplate(String metricIdTemplate) {
        this.metricIdTemplate = metricIdTemplate;
    }

    public Map<String, String> getMetricTags() {
        return this.metricTags;
    }

    public void setMetricTags(Map<String, String> metricTags) {
        this.metricTags = metricTags;
    }

    public Avail getSetAvailOnShutdown() {
        return this.setAvailOnShutdown;
    }

    public void setSetAvailOnShutdown(Avail setAvailOnShutdown) {
        this.setAvailOnShutdown = setAvailOnShutdown;
    }
}

