/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.hawkular.agent.javaagent.config.StringExpression;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class SecurityRealm
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty(value="keystore-path", required=true)
    private StringExpression keystorePath;
    @JsonProperty(value="keystore-password", required=true)
    private StringExpression keystorePassword;
    @JsonProperty(value="key-password")
    private StringExpression keyPassword;
    @JsonProperty(value="keystore-type")
    private String keystoreType = KeyStore.getDefaultType();
    @JsonProperty(value="key-manager-algorithm")
    private String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    @JsonProperty(value="trust-manager-algorithm")
    private String trustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    @JsonProperty(value="ssl-protocol")
    private String sslProtocol = "TLSv1";

    public SecurityRealm() {
    }

    public SecurityRealm(SecurityRealm original) {
        this.name = original.name;
        this.keystorePath = original.keystorePath == null ? null : new StringExpression(original.keystorePath);
        this.keystorePassword = original.keystorePassword == null ? null : new StringExpression(original.keystorePassword);
        this.keyPassword = original.keyPassword == null ? null : new StringExpression(original.keyPassword);
        this.keystoreType = original.keystoreType;
        this.keyManagerAlgorithm = original.keyManagerAlgorithm;
        this.trustManagerAlgorithm = original.trustManagerAlgorithm;
        this.sslProtocol = original.sslProtocol;
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("security-realm name must be specified");
        }
        if (this.keystorePath == null || ((StringExpression.StringValue)this.keystorePath.get()).toString().trim().length() == 0) {
            throw new Exception("security-realm: [" + this.name + "] keystore-path must be specified");
        }
        if (this.keystorePassword == null || ((StringExpression.StringValue)this.keystorePassword.get()).toString().trim().length() == 0) {
            throw new Exception("security-realm: [" + this.name + "] keystore-password must be specified");
        }
        try {
            KeyStore.getInstance(this.keystoreType);
        }
        catch (Exception e) {
            throw new Exception("security-realm: [" + this.name + "] keystore-type [" + this.keystoreType + "] is invalid. You may want to use the VM default of [" + KeyStore.getDefaultType() + "]", e);
        }
        try {
            KeyManagerFactory.getInstance(this.keyManagerAlgorithm);
        }
        catch (Exception e) {
            throw new Exception("security-realm: [" + this.name + "] key-manager-algorithm [" + this.keyManagerAlgorithm + "] is invalid. You may want to use the VM default of [" + KeyManagerFactory.getDefaultAlgorithm() + "]", e);
        }
        try {
            TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
        }
        catch (Exception e) {
            throw new Exception("security-realm: [" + this.name + "] trust-manager-algorithm [" + this.trustManagerAlgorithm + "] is invalid. You may want to use the VM default of [" + TrustManagerFactory.getDefaultAlgorithm() + "]", e);
        }
        try {
            SSLContext.getInstance(this.sslProtocol);
        }
        catch (Exception e) {
            throw new Exception("security-realm: [" + this.name + "] ssl-protocol [" + this.sslProtocol + "] is invalid. You may want to use [TLSv1]", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKeystorePath() {
        return this.keystorePath == null ? null : ((StringExpression.StringValue)this.keystorePath.get()).toString();
    }

    public void setKeystorePath(String keystorePath) {
        if (this.keystorePath != null) {
            this.keystorePath.set(new StringExpression.StringValue(keystorePath));
        } else {
            this.keystorePath = new StringExpression(new StringExpression.StringValue(keystorePath));
        }
    }

    public String getKeystorePassword() {
        return this.keystorePassword == null ? null : ((StringExpression.StringValue)this.keystorePassword.get()).toString();
    }

    public void setKeystorePassword(String keystorePassword) {
        if (this.keystorePassword != null) {
            this.keystorePassword.set(new StringExpression.StringValue(keystorePassword));
        } else {
            this.keystorePassword = new StringExpression(new StringExpression.StringValue(keystorePassword));
        }
    }

    public String getKeyPassword() {
        return this.keyPassword == null ? null : ((StringExpression.StringValue)this.keyPassword.get()).toString();
    }

    public void setKeyPassword(String keyPassword) {
        if (this.keyPassword != null) {
            this.keyPassword.set(new StringExpression.StringValue(keyPassword));
        } else {
            this.keyPassword = new StringExpression(new StringExpression.StringValue(keyPassword));
        }
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getKeyManagerAlgorithm() {
        return this.keyManagerAlgorithm;
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this.keyManagerAlgorithm = keyManagerAlgorithm;
    }

    public String getTrustManagerAlgorithm() {
        return this.trustManagerAlgorithm;
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.trustManagerAlgorithm = trustManagerAlgorithm;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }
}

