/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URL;
import org.hawkular.agent.javaagent.config.StringExpression;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class StorageAdapter
implements Validatable {
    @JsonProperty
    private Type type = Type.HAWKULAR;
    @JsonProperty
    private StringExpression url = new StringExpression("http://127.0.0.1:8080");
    @JsonProperty(value="tenant-id")
    private StringExpression tenantId = new StringExpression("hawkular");
    @JsonProperty
    private StringExpression username = new StringExpression("");
    @JsonProperty
    private StringExpression password = new StringExpression("");
    @JsonProperty(value="feed-id")
    private StringExpression feedId = new StringExpression("autogenerate");
    @JsonProperty(value="security-realm")
    private String securityRealmName;
    @JsonProperty(value="inventory-context")
    private String inventoryContext = "/hawkular/inventory/";
    @JsonProperty(value="metrics-context")
    private String metricsContext = "/hawkular/metrics/";
    @JsonProperty(value="feedcomm-context")
    private String feedcommContext = "/hawkular/command-gateway/";
    @JsonProperty(value="connect-timeout-secs")
    private Integer connectTimeoutSecs = 10;
    @JsonProperty(value="read-timeout-secs")
    private Integer readTimeoutSecs = 120;

    public StorageAdapter() {
    }

    public StorageAdapter(StorageAdapter original) {
        this.type = original.type;
        this.url = original.url == null ? null : new StringExpression(original.url);
        this.tenantId = original.tenantId == null ? null : new StringExpression(original.tenantId);
        this.username = original.username == null ? null : new StringExpression(original.username);
        this.password = original.password == null ? null : new StringExpression(original.password);
        this.feedId = original.feedId == null ? null : new StringExpression(original.feedId);
        this.securityRealmName = original.securityRealmName;
        this.inventoryContext = original.inventoryContext;
        this.metricsContext = original.metricsContext;
        this.feedcommContext = original.feedcommContext;
        this.connectTimeoutSecs = original.connectTimeoutSecs;
        this.readTimeoutSecs = original.readTimeoutSecs;
    }

    public boolean useSSL() {
        return this.url != null && ((StringExpression.StringValue)this.url.get()).toString().startsWith("https:");
    }

    @Override
    public void validate() throws Exception {
        try {
            new URL(((StringExpression.StringValue)this.url.get()).toString());
        }
        catch (Exception e) {
            throw new Exception("storage-adapter url is invalid", e);
        }
        if (this.connectTimeoutSecs != null && this.connectTimeoutSecs <= 0) {
            throw new Exception("storage-adapter connect-timeout-secs must be greater than or equal to 0");
        }
        if (this.readTimeoutSecs != null && this.readTimeoutSecs <= 0) {
            throw new Exception("storage-adapter read-timeout-secs must be greater than or equal to 0");
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url == null ? null : ((StringExpression.StringValue)this.url.get()).toString();
    }

    public void setUrl(String url) {
        if (this.url != null) {
            this.url.set(new StringExpression.StringValue(url));
        } else {
            this.url = new StringExpression(new StringExpression.StringValue(url));
        }
    }

    public String getTenantId() {
        return this.tenantId == null ? null : ((StringExpression.StringValue)this.tenantId.get()).toString();
    }

    public void setTenantId(String tenantId) {
        if (this.tenantId != null) {
            this.tenantId.set(new StringExpression.StringValue(tenantId));
        } else {
            this.tenantId = new StringExpression(tenantId);
        }
    }

    public String getUsername() {
        return this.username == null ? null : ((StringExpression.StringValue)this.username.get()).toString();
    }

    public void setUsername(String username) {
        if (this.username != null) {
            this.username.set(new StringExpression.StringValue(username));
        } else {
            this.username = new StringExpression(new StringExpression.StringValue(username));
        }
    }

    public String getPassword() {
        return this.password == null ? null : ((StringExpression.StringValue)this.password.get()).toString();
    }

    public void setPassword(String password) {
        if (this.password != null) {
            this.password.set(new StringExpression.StringValue(password));
        } else {
            this.password = new StringExpression(new StringExpression.StringValue(password));
        }
    }

    public String getFeedId() {
        return this.feedId == null ? null : ((StringExpression.StringValue)this.feedId.get()).toString();
    }

    public void setFeedId(String feedId) {
        if (this.feedId != null) {
            this.feedId.set(new StringExpression.StringValue(feedId));
        } else {
            this.feedId = new StringExpression(new StringExpression.StringValue(feedId));
        }
    }

    public String getSecurityRealmName() {
        return this.securityRealmName;
    }

    public void setSecurityRealmName(String securityRealmName) {
        this.securityRealmName = securityRealmName;
    }

    public String getInventoryContext() {
        return this.inventoryContext;
    }

    public void setInventoryContext(String inventoryContext) {
        this.inventoryContext = inventoryContext;
    }

    public String getMetricsContext() {
        return this.metricsContext;
    }

    public void setMetricsContext(String metricsContext) {
        this.metricsContext = metricsContext;
    }

    public String getFeedcommContext() {
        return this.feedcommContext;
    }

    public void setFeedcommContext(String feedcommContext) {
        this.feedcommContext = feedcommContext;
    }

    public Integer getConnectTimeoutSecs() {
        return this.connectTimeoutSecs;
    }

    public void setConnectTimeoutSecs(Integer connectTimeoutSecs) {
        this.connectTimeoutSecs = connectTimeoutSecs;
    }

    public Integer getReadTimeoutSecs() {
        return this.readTimeoutSecs;
    }

    public void setReadTimeoutSecs(Integer readTimeoutSecs) {
        this.readTimeoutSecs = readTimeoutSecs;
    }

    public static enum Type {
        HAWKULAR,
        METRICS;

    }
}

