/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import java.net.URI;
import java.net.URISyntaxException;

public class ConnectionData {
    private final String password;
    private final URI uri;
    private final String username;

    private static URI createUri(String protocol, String host, int port) {
        try {
            return new URI(protocol, null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectionData(String protocol, String host, int port, String username, String password) {
        this(ConnectionData.createUri(protocol, host, port), username, password);
    }

    public ConnectionData(URI uri, String username, String password) {
        if (uri == null) {
            throw new IllegalArgumentException("Cannot create a new [" + this.getClass().getName() + "] with a new uri");
        }
        this.uri = uri;
        this.username = username;
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getUsername() {
        return this.username;
    }

    public String toString() {
        return this.getUri().toString();
    }
}

