/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import javax.net.ssl.SSLContext;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.ConnectionData;

public final class MonitoredEndpoint<C extends AgentCoreEngineConfiguration.AbstractEndpointConfiguration> {
    private final C endpointConfiguration;
    private final SSLContext sslContext;

    public static <C extends AgentCoreEngineConfiguration.AbstractEndpointConfiguration> MonitoredEndpoint<C> of(C endpointConfiguration, SSLContext sslContext) {
        return new MonitoredEndpoint<C>(endpointConfiguration, sslContext);
    }

    private MonitoredEndpoint(C endpointConfiguration, SSLContext sslContext) {
        if (endpointConfiguration == null) {
            throw new IllegalArgumentException("Cannot create a new [" + this.getClass().getName() + "] without a config");
        }
        if (((AgentCoreEngineConfiguration.AbstractEndpointConfiguration)endpointConfiguration).getName() == null) {
            throw new IllegalArgumentException("Cannot create a new [" + this.getClass().getName() + "] with a null name");
        }
        this.endpointConfiguration = endpointConfiguration;
        this.sslContext = sslContext;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MonitoredEndpoint)) {
            return false;
        }
        return ((AgentCoreEngineConfiguration.AbstractEndpointConfiguration)this.endpointConfiguration).getName().equals(((AgentCoreEngineConfiguration.AbstractEndpointConfiguration)((MonitoredEndpoint)obj).endpointConfiguration).getName());
    }

    public C getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public ConnectionData getConnectionData() {
        return ((AgentCoreEngineConfiguration.AbstractEndpointConfiguration)this.endpointConfiguration).getConnectionData();
    }

    public String getName() {
        return ((AgentCoreEngineConfiguration.AbstractEndpointConfiguration)this.endpointConfiguration).getName();
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public int hashCode() {
        return ((AgentCoreEngineConfiguration.AbstractEndpointConfiguration)this.endpointConfiguration).getName().hashCode();
    }

    public boolean isLocal() {
        return ((AgentCoreEngineConfiguration.AbstractEndpointConfiguration)this.endpointConfiguration).getConnectionData() == null;
    }

    public String toString() {
        return String.format("Endpoint[%s]:[%s]", this.getName(), this.getConnectionData());
    }
}

