/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.agent.monitor.api.InventoryListener;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.Session;
import org.hawkular.agent.monitor.scheduler.SchedulerService;

public class ProtocolService<L, S extends Session<L>> {
    private static final MsgLogger log = AgentLoggers.getLogger(ProtocolService.class);
    private final String name;
    private final Map<String, EndpointService<L, S>> endpointServices;
    private final List<InventoryListener> inventoryListeners = Collections.synchronizedList(new ArrayList());

    public static <L, S extends Session<L>> Builder<L, S> builder(String name) {
        return new Builder().name(name);
    }

    public ProtocolService(String name, Map<String, EndpointService<L, S>> endpointServices) {
        this.name = name;
        this.endpointServices = endpointServices;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EndpointService<L, S>> getEndpointServices() {
        Map<String, EndpointService<L, S>> map = this.endpointServices;
        synchronized (map) {
            return new HashMap<String, EndpointService<L, S>>(this.endpointServices);
        }
    }

    public void discoverAll() {
        for (EndpointService<L, S> service : this.getEndpointServices().values()) {
            service.discoverAll();
        }
    }

    public void start() {
        for (EndpointService<L, S> service : this.getEndpointServices().values()) {
            service.start();
        }
    }

    public void stop() {
        for (EndpointService<L, S> service : this.getEndpointServices().values()) {
            service.stop();
        }
    }

    public void addInventoryListener(InventoryListener listener) {
        for (EndpointService<L, S> service : this.getEndpointServices().values()) {
            service.addInventoryListener(listener);
        }
        this.inventoryListeners.add(listener);
    }

    public void removeInventoryListener(InventoryListener listener) {
        for (EndpointService<L, S> service : this.getEndpointServices().values()) {
            service.removeInventoryListener(listener);
        }
        this.inventoryListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EndpointService<L, S> newEndpointService) {
        if (newEndpointService == null) {
            throw new IllegalArgumentException("New endpoint service must not be null");
        }
        List<InventoryListener> list = this.inventoryListeners;
        synchronized (list) {
            for (InventoryListener listener : this.inventoryListeners) {
                newEndpointService.addInventoryListener(listener);
            }
        }
        this.endpointServices.put(newEndpointService.getMonitoredEndpoint().getName(), newEndpointService);
        newEndpointService.start();
        log.infoAddedEndpointService(newEndpointService.toString());
        newEndpointService.discoverAll();
    }

    public void remove(String name, SchedulerService scheduler) {
        EndpointService<L, S> service = this.endpointServices.remove(name);
        if (service != null) {
            service.stop();
            List<Resource<L>> allResources = service.getResourceManager().getResourcesBreadthFirst();
            scheduler.unschedule(service, allResources);
            log.infoRemovedEndpointService(service.toString());
        }
    }

    public static class Builder<L, S extends Session<L>> {
        private String name;
        private Map<String, EndpointService<L, S>> endpointServices = new HashMap<String, EndpointService<L, S>>();

        private Builder() {
        }

        public ProtocolService<L, S> build() {
            return new ProtocolService<L, S>(this.name, Collections.synchronizedMap(this.endpointServices));
        }

        public Builder<L, S> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<L, S> endpointService(EndpointService<L, S> endpointService) {
            this.endpointServices.put(endpointService.getMonitoredEndpoint().getName(), endpointService);
            return this;
        }
    }
}

