/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.dmr;

import org.hawkular.agent.monitor.inventory.NodeLocation;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;

public class DMRNodeLocation
implements NodeLocation {
    private static final DMRNodeLocation EMPTY = new DMRNodeLocation(PathAddress.EMPTY_ADDRESS, true, true);
    private final PathAddress pathAddress;
    private final boolean resolveExpressions;
    private final boolean includeDefaults;

    public static DMRNodeLocation empty() {
        return EMPTY;
    }

    public static DMRNodeLocation of(ModelNode addressNode) {
        return DMRNodeLocation.of(addressNode, true, true);
    }

    public static DMRNodeLocation of(ModelNode addressNode, boolean resolveExpressions, boolean includeDefaults) {
        return new DMRNodeLocation(PathAddress.pathAddress(addressNode), resolveExpressions, includeDefaults);
    }

    public static DMRNodeLocation of(String path) {
        return DMRNodeLocation.of(path, true, true);
    }

    public static DMRNodeLocation of(String path, boolean resolveExpressions, boolean includeDefaults) {
        return new DMRNodeLocation("/".equals(path) ? PathAddress.EMPTY_ADDRESS : WildflyCompatibilityUtils.parseCLIStyleAddress(path), resolveExpressions, includeDefaults);
    }

    public DMRNodeLocation(PathAddress pathAddress) {
        this(pathAddress, true, true);
    }

    public DMRNodeLocation(PathAddress pathAddress, boolean resolveExpressions, boolean includeDefaults) {
        if (pathAddress == null) {
            throw new IllegalArgumentException("Cannot create a new [" + this.getClass().getName() + "] with a null pathAddress");
        }
        this.pathAddress = pathAddress;
        this.resolveExpressions = resolveExpressions;
        this.includeDefaults = includeDefaults;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DMRNodeLocation other = (DMRNodeLocation)obj;
        return !(this.pathAddress == null ? other.pathAddress != null : !this.pathAddress.equals(other.pathAddress));
    }

    public PathAddress getPathAddress() {
        return this.pathAddress;
    }

    public int hashCode() {
        return this.pathAddress.hashCode();
    }

    public String toString() {
        return this.pathAddress.toCLIStyleString();
    }

    public boolean getResolveExpressions() {
        return this.resolveExpressions;
    }

    public boolean getIncludeDefaults() {
        return this.includeDefaults;
    }
}

