/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.platform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hawkular.agent.monitor.protocol.platform.Constants;

public class PlatformPath {
    public static final String ANY_NAME = "*";
    private static final PlatformPath EMPTY = new PlatformPath(Collections.emptyList());
    private final List<PathSegment> segments;

    public static Builder builder() {
        return new Builder();
    }

    public static PlatformPath empty() {
        return EMPTY;
    }

    private PlatformPath(List<PathSegment> segments) {
        this.segments = segments;
    }

    public PathSegment getLastSegment() {
        if (this.segments.isEmpty()) {
            throw new IndexOutOfBoundsException("No last segment in empty [" + this.getClass().getName() + "]");
        }
        return this.segments.get(this.segments.size() - 1);
    }

    public List<PathSegment> getSegments() {
        return this.segments;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (PathSegment segment : this.segments) {
            result.append('/').append((Object)segment.getType()).append('=').append(segment.getName());
        }
        return result.toString();
    }

    public boolean apply(PlatformPath other) {
        if (this.segments.size() == other.segments.size()) {
            for (int i = 0; i < this.segments.size(); ++i) {
                if (this.segments.get(i).apply(other.segments.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isParentOf(PlatformPath other) {
        if (this.segments.size() <= other.segments.size()) {
            for (int i = 0; i < this.segments.size(); ++i) {
                if (this.segments.get(i).apply(other.segments.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class PathSegment {
        private final String name;
        private final Constants.PlatformResourceType type;

        private PathSegment(Constants.PlatformResourceType type, String name) {
            if (type == null) {
                throw new IllegalArgumentException("Cannot create a [" + this.getClass().getName() + "] with a null type.");
            }
            if (name == null) {
                throw new IllegalArgumentException("Cannot create a [" + this.getClass().getName() + "] with a null type.");
            }
            this.type = type;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Constants.PlatformResourceType getType() {
            return this.type;
        }

        public boolean apply(PathSegment other) {
            return this.type.equals((Object)other.type) && (this.name.equals(other.name) || this.name.equals(PlatformPath.ANY_NAME));
        }
    }

    public static class Builder {
        private List<PathSegment> segments = new ArrayList<PathSegment>();

        public Builder any(Constants.PlatformResourceType type) {
            this.segments.add(new PathSegment(type, PlatformPath.ANY_NAME));
            return this;
        }

        public PlatformPath build() {
            return new PlatformPath(Collections.unmodifiableList(this.segments));
        }

        public Builder segment(Constants.PlatformResourceType type, String name) {
            this.segments.add(new PathSegment(type, name));
            return this;
        }

        public Builder segments(List<PathSegment> segmentsToAdd, int start, int end) {
            for (int i = start; i < end; ++i) {
                this.segments.add(segmentsToAdd.get(i));
            }
            return this;
        }

        public Builder segments(PlatformPath path) {
            this.segments.addAll(path.getSegments());
            return this;
        }
    }
}

