/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.api.AvailDataPayloadBuilder;
import org.hawkular.agent.monitor.api.DiscoveryEvent;
import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.MetricDataPayloadBuilder;
import org.hawkular.agent.monitor.api.MetricTagPayloadBuilder;
import org.hawkular.agent.monitor.api.SamplingService;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.storage.AsyncInventoryStorage;
import org.hawkular.agent.monitor.storage.AvailDataPayloadBuilderImpl;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.storage.DataPoint;
import org.hawkular.agent.monitor.storage.HttpClientBuilder;
import org.hawkular.agent.monitor.storage.MetricDataPayloadBuilderImpl;
import org.hawkular.agent.monitor.storage.MetricDataPoint;
import org.hawkular.agent.monitor.storage.MetricTagPayloadBuilderImpl;
import org.hawkular.agent.monitor.storage.NumericMetricDataPoint;
import org.hawkular.agent.monitor.storage.StorageAdapter;
import org.hawkular.agent.monitor.storage.StringMetricDataPoint;
import org.hawkular.agent.monitor.util.Util;

public class HawkularStorageAdapter
implements StorageAdapter {
    private static final MsgLogger log = AgentLoggers.getLogger(HawkularStorageAdapter.class);
    private AgentCoreEngineConfiguration.StorageAdapterConfiguration config;
    private Diagnostics diagnostics;
    private HttpClientBuilder httpClientBuilder;
    private AsyncInventoryStorage inventoryStorage;
    private Map<String, String> agentTenantIdHeader;

    @Override
    public void initialize(String feedId, AgentCoreEngineConfiguration.StorageAdapterConfiguration config, Diagnostics diag, HttpClientBuilder httpClientBuilder) {
        this.config = config;
        this.diagnostics = diag;
        this.httpClientBuilder = httpClientBuilder;
        this.agentTenantIdHeader = this.getTenantHeader(config.getTenantId());
        switch (config.getType()) {
            case HAWKULAR: {
                this.inventoryStorage = new AsyncInventoryStorage(feedId, config, httpClientBuilder, this.diagnostics);
                break;
            }
            case METRICS: {
                this.inventoryStorage = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type. Please report this bug: " + (Object)((Object)config.getType()));
            }
        }
    }

    @Override
    public AgentCoreEngineConfiguration.StorageAdapterConfiguration getStorageAdapterConfiguration() {
        return this.config;
    }

    @Override
    public MetricDataPayloadBuilder createMetricDataPayloadBuilder() {
        return new MetricDataPayloadBuilderImpl();
    }

    @Override
    public AvailDataPayloadBuilder createAvailDataPayloadBuilder() {
        return new AvailDataPayloadBuilderImpl();
    }

    @Override
    public MetricTagPayloadBuilder createMetricTagPayloadBuilder() {
        return new MetricTagPayloadBuilderImpl();
    }

    @Override
    public void storeMetrics(Set<MetricDataPoint> datapoints, long waitMillis) {
        if (datapoints == null || datapoints.isEmpty()) {
            return;
        }
        Map<String, Set<MetricDataPoint>> byTenantId = this.separateByTenantId(datapoints);
        for (Map.Entry<String, Set<MetricDataPoint>> entry : byTenantId.entrySet()) {
            String tenantId = entry.getKey();
            Set<MetricDataPoint> tenantDataPoints = entry.getValue();
            MetricDataPayloadBuilder payloadBuilder = this.createMetricDataPayloadBuilder();
            payloadBuilder.setTenantId(tenantId);
            for (MetricDataPoint datapoint : tenantDataPoints) {
                long timestamp = datapoint.getTimestamp();
                if (datapoint instanceof NumericMetricDataPoint) {
                    double value = ((NumericMetricDataPoint)datapoint).getMetricValue();
                    payloadBuilder.addDataPoint(datapoint.getKey(), timestamp, value, datapoint.getMetricType());
                    continue;
                }
                if (datapoint instanceof StringMetricDataPoint) {
                    String value = ((StringMetricDataPoint)datapoint).getMetricValue();
                    payloadBuilder.addDataPoint(datapoint.getKey(), timestamp, value);
                    continue;
                }
                log.errorf("Invalid data point type [%s] - please report this bug", (Object)datapoint.getClass());
            }
            this.store(payloadBuilder, waitMillis);
        }
    }

    @Override
    public void store(final MetricDataPayloadBuilder payloadBuilder, long waitMillis) {
        String jsonPayload = "?";
        try {
            String metricTenantId = payloadBuilder.getTenantId();
            Map<String, String> tenantIdHeader = metricTenantId == null ? this.agentTenantIdHeader : this.getTenantHeader(metricTenantId);
            jsonPayload = payloadBuilder.toPayload().toString();
            StringBuilder url = Util.getContextUrlString(this.config.getUrl(), this.config.getMetricsContext());
            url.append("metrics/data");
            final Request request = this.httpClientBuilder.buildJsonPostRequest(url.toString(), tenantIdHeader, jsonPayload);
            final CountDownLatch latch = waitMillis <= 0L ? null : new CountDownLatch(1);
            final String jsonPayloadFinal = jsonPayload;
            this.httpClientBuilder.getHttpClient().newCall(request).enqueue(new Callback(){

                @Override
                public void onFailure(Call call, IOException e) {
                    try {
                        log.errorFailedToStoreMetricData(e, jsonPayloadFinal);
                        HawkularStorageAdapter.this.diagnostics.getStorageErrorRate().mark(1L);
                    }
                    finally {
                        if (latch != null) {
                            latch.countDown();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(Call call, Response response) throws IOException {
                    try {
                        if (response.code() != 200) {
                            IOException e = new IOException("status-code=[" + response.code() + "], reason=[" + response.message() + "], url=[" + request.url().toString() + "]");
                            log.errorFailedToStoreMetricData(e, jsonPayloadFinal);
                            HawkularStorageAdapter.this.diagnostics.getStorageErrorRate().mark(1L);
                        } else {
                            HawkularStorageAdapter.this.diagnostics.getMetricRate().mark(payloadBuilder.getNumberDataPoints());
                        }
                    }
                    finally {
                        if (latch != null) {
                            latch.countDown();
                        }
                        response.body().close();
                    }
                }
            });
            if (latch != null) {
                latch.await(waitMillis, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable t) {
            log.errorFailedToStoreMetricData(t, jsonPayload);
            this.diagnostics.getStorageErrorRate().mark(1L);
        }
    }

    @Override
    public void storeAvails(Set<AvailDataPoint> datapoints, long waitMillis) {
        if (datapoints == null || datapoints.isEmpty()) {
            return;
        }
        Map<String, Set<AvailDataPoint>> byTenantId = this.separateByTenantId(datapoints);
        for (Map.Entry<String, Set<AvailDataPoint>> entry : byTenantId.entrySet()) {
            String tenantId = entry.getKey();
            Set<AvailDataPoint> tenantDataPoints = entry.getValue();
            AvailDataPayloadBuilder payloadBuilder = this.createAvailDataPayloadBuilder();
            payloadBuilder.setTenantId(tenantId);
            for (AvailDataPoint datapoint : tenantDataPoints) {
                long timestamp = datapoint.getTimestamp();
                Avail value = datapoint.getValue();
                payloadBuilder.addDataPoint(datapoint.getKey(), timestamp, value);
            }
            this.store(payloadBuilder, waitMillis);
        }
    }

    @Override
    public void store(final AvailDataPayloadBuilder payloadBuilder, long waitMillis) {
        String jsonPayload = "?";
        try {
            String metricTenantId = payloadBuilder.getTenantId();
            Map<String, String> tenantIdHeader = metricTenantId == null ? this.agentTenantIdHeader : this.getTenantHeader(metricTenantId);
            jsonPayload = payloadBuilder.toPayload().toString();
            StringBuilder url = Util.getContextUrlString(this.config.getUrl(), this.config.getMetricsContext());
            url.append("availability/data");
            final Request request = this.httpClientBuilder.buildJsonPostRequest(url.toString(), tenantIdHeader, jsonPayload);
            final CountDownLatch latch = waitMillis <= 0L ? null : new CountDownLatch(1);
            final String jsonPayloadFinal = jsonPayload;
            this.httpClientBuilder.getHttpClient().newCall(request).enqueue(new Callback(){

                @Override
                public void onFailure(Call call, IOException e) {
                    try {
                        log.errorFailedToStoreAvailData(e, jsonPayloadFinal);
                        HawkularStorageAdapter.this.diagnostics.getStorageErrorRate().mark(1L);
                    }
                    finally {
                        if (latch != null) {
                            latch.countDown();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(Call call, Response response) throws IOException {
                    try {
                        if (response.code() != 200) {
                            IOException e = new IOException("status-code=[" + response.code() + "], reason=[" + response.message() + "], url=[" + request.url().toString() + "]");
                            log.errorFailedToStoreAvailData(e, jsonPayloadFinal);
                            HawkularStorageAdapter.this.diagnostics.getStorageErrorRate().mark(1L);
                        } else {
                            HawkularStorageAdapter.this.diagnostics.getAvailRate().mark(payloadBuilder.getNumberDataPoints());
                        }
                    }
                    finally {
                        if (latch != null) {
                            latch.countDown();
                        }
                        response.body().close();
                    }
                }
            });
            if (latch != null) {
                latch.await(waitMillis, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable t) {
            log.errorFailedToStoreAvailData(t, jsonPayload);
            this.diagnostics.getStorageErrorRate().mark(1L);
        }
    }

    @Override
    public void store(MetricTagPayloadBuilder payloadBuilder, long waitMillis) {
        Map<String, String> jsonPayloads = null;
        try {
            String metricTenantId = payloadBuilder.getTenantId();
            Map<String, String> tenantIdHeader = metricTenantId == null ? this.agentTenantIdHeader : this.getTenantHeader(metricTenantId);
            jsonPayloads = payloadBuilder.toPayload();
            String url = Util.getContextUrlString(this.config.getUrl(), this.config.getMetricsContext()).toString();
            for (Map.Entry<String, String> jsonPayload : jsonPayloads.entrySet()) {
                String relativePath = jsonPayload.getKey();
                final String tagsJson = jsonPayload.getValue();
                String currentUrl = url + relativePath + "/tags";
                final Request request = this.httpClientBuilder.buildJsonPutRequest(currentUrl, tenantIdHeader, tagsJson);
                final CountDownLatch latch = waitMillis <= 0L ? null : new CountDownLatch(1);
                this.httpClientBuilder.getHttpClient().newCall(request).enqueue(new Callback(){

                    @Override
                    public void onFailure(Call call, IOException e) {
                        try {
                            log.errorFailedToStoreMetricTags(e, tagsJson);
                            HawkularStorageAdapter.this.diagnostics.getStorageErrorRate().mark(1L);
                        }
                        finally {
                            if (latch != null) {
                                latch.countDown();
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onResponse(Call call, Response response) throws IOException {
                        try {
                            if (response.code() != 200) {
                                IOException e = new IOException("status-code=[" + response.code() + "], reason=[" + response.message() + "], url=[" + request.url().toString() + "]");
                                log.errorFailedToStoreMetricTags(e, tagsJson);
                                HawkularStorageAdapter.this.diagnostics.getStorageErrorRate().mark(1L);
                            }
                        }
                        finally {
                            if (latch != null) {
                                latch.countDown();
                            }
                            response.body().close();
                        }
                    }
                });
                if (latch == null) continue;
                latch.await(waitMillis, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable t) {
            log.errorFailedToStoreMetricTags(t, jsonPayloads == null ? "?" : jsonPayloads.toString());
            this.diagnostics.getStorageErrorRate().mark(1L);
        }
    }

    @Override
    public <L> void resourcesAdded(InventoryEvent<L> event) {
        if (this.inventoryStorage != null) {
            this.inventoryStorage.resourcesAdded(event);
        }
        SamplingService<L> service = event.getSamplingService();
        for (Resource<L> resource : event.getPayload()) {
            MetricTagPayloadBuilder bldr = this.createMetricTagPayloadBuilder();
            Collection<MeasurementInstance<L, MetricType<L>>> metrics = resource.getMetrics();
            for (MeasurementInstance<L, MetricType<L>> metric : metrics) {
                Map<String, String> tags = service.generateAssociatedMetricTags(metric);
                if (tags.isEmpty()) continue;
                for (Map.Entry<String, String> tag : tags.entrySet()) {
                    bldr.addTag(metric.getAssociatedMetricId(), tag.getKey(), tag.getValue(), ((MetricType)metric.getType()).getMetricType());
                }
            }
            Collection<MeasurementInstance<L, AvailType<L>>> avails = resource.getAvails();
            for (MeasurementInstance<L, AvailType<L>> avail : avails) {
                Map<String, String> tags = service.generateAssociatedMetricTags(avail);
                if (tags.isEmpty()) continue;
                for (Map.Entry<String, String> tag : tags.entrySet()) {
                    bldr.addTag(avail.getAssociatedMetricId(), tag.getKey(), tag.getValue(), org.hawkular.metrics.client.common.MetricType.AVAILABILITY);
                }
            }
            if (bldr.getNumberTags() <= 0) continue;
            this.store(bldr, 0L);
        }
    }

    @Override
    public <L> void resourcesRemoved(InventoryEvent<L> event) {
        if (this.inventoryStorage != null) {
            this.inventoryStorage.resourcesRemoved(event);
        }
    }

    @Override
    public <L> void discoveryCompleted(DiscoveryEvent<L> event) {
        if (this.inventoryStorage != null) {
            this.inventoryStorage.discoveryCompleted(event);
        }
    }

    @Override
    public void shutdown() {
        if (this.inventoryStorage != null) {
            this.inventoryStorage.shutdown();
        }
    }

    private Map<String, String> getTenantHeader(String tenantId) {
        return Collections.singletonMap("Hawkular-Tenant", tenantId);
    }

    private <T extends DataPoint> Map<String, Set<T>> separateByTenantId(Set<T> dataPoints) {
        HashMap<String, Set<T>> byTenant = new HashMap<String, Set<T>>();
        for (DataPoint dp : dataPoints) {
            HashSet<DataPoint> tenantDataPoints = (HashSet<DataPoint>)byTenant.get(dp.getTenantId());
            if (tenantDataPoints == null) {
                tenantDataPoints = new HashSet<DataPoint>();
                byTenant.put(dp.getTenantId(), tenantDataPoints);
            }
            tenantDataPoints.add(dp);
        }
        return byTenant;
    }
}

