/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.stream.Collectors;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.inventory.json.InventoryJacksonConfig;

public class Util {
    private static final MsgLogger log = AgentLoggers.getLogger(Util.class);
    private static final String ENCODING_UTF_8 = "utf-8";
    private static final int BUFFER_SIZE = 128;
    private static final String HAWKULAR_AGENT_MACHINE_ID = "hawkular.agent.machine.id";
    private static ObjectMapper mapper;
    private static String systemId;

    public static String toJson(Object obj) {
        String json;
        try {
            json = mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Object cannot be parsed as JSON", e);
        }
        return json;
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        T obj;
        try {
            obj = mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("JSON message cannot be converted to object of type:" + clazz, e);
        }
        return obj;
    }

    public static <T> T fromJson(Reader in, TypeReference<T> typeReference) {
        Object obj;
        try {
            obj = mapper.readValue(in, typeReference);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("JSON message cannot be converted to object of type:" + typeReference, e);
        }
        return obj;
    }

    public static String urlEncode(String str) {
        try {
            String encodeForForm = URLEncoder.encode(str, "UTF-8");
            String encodeForUrl = encodeForForm.replace("+", "%20");
            return encodeForUrl;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM does not support UTF-8");
        }
    }

    public static String urlEncodeQuery(String str) {
        try {
            String encodeForForm = URLEncoder.encode(str, "UTF-8");
            return encodeForForm;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM does not support UTF-8");
        }
    }

    public static StringBuilder getContextUrlString(String baseUrl, String context) throws MalformedURLException {
        StringBuilder urlStr = new StringBuilder(baseUrl);
        Util.ensureEndsWithSlash(urlStr);
        if (context != null && context.length() > 0) {
            if (context.startsWith("/")) {
                urlStr.append(context.substring(1));
            } else {
                urlStr.append(context);
            }
            Util.ensureEndsWithSlash(urlStr);
        }
        return urlStr;
    }

    public static void ensureEndsWithSlash(StringBuilder str) {
        if (str.length() == 0 || str.charAt(str.length() - 1) != '/') {
            str.append('/');
        }
    }

    public static long copyStream(InputStream input, OutputStream output, boolean closeStreams) throws RuntimeException {
        long numBytesCopied = 0L;
        int bufferSize = 128;
        try {
            input = new BufferedInputStream(input, bufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = input.read(buffer);
            while (bytesRead != -1) {
                output.write(buffer, 0, bytesRead);
                numBytesCopied += (long)bytesRead;
                bytesRead = input.read(buffer);
            }
            output.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Stream data cannot be copied", ioe);
        }
        finally {
            if (closeStreams) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return numBytesCopied;
    }

    public static String slurpStream(InputStream input, String encoding) throws IOException {
        try (InputStreamReader r = new InputStreamReader(input, encoding);){
            StringBuilder result = new StringBuilder();
            char[] buffer = new char[128];
            int len = 0;
            while ((len = ((Reader)r).read(buffer, 0, 128)) >= 0) {
                result.append(buffer, 0, len);
            }
            String string = result.toString();
            return string;
        }
    }

    public static String read(File file) throws IOException {
        return Util.slurpStream(new FileInputStream(file), ENCODING_UTF_8);
    }

    public static void write(String string, File file) throws IOException {
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING_UTF_8);){
            w.write(string);
        }
    }

    public static String base64Encode(String plainTextString) {
        String encoded = new String(Base64.getEncoder().encode(plainTextString.getBytes()));
        return encoded;
    }

    public static String getSystemId() {
        if (systemId == null && (systemId = System.getProperty(HAWKULAR_AGENT_MACHINE_ID)) != null) {
            log.infof("MachineId was explicitly set to [%s]", (Object)systemId);
        }
        if (systemId == null) {
            File machineIdFile = new File("/etc/machine-id");
            if (machineIdFile.exists() && machineIdFile.canRead()) {
                try (InputStreamReader reader = new InputStreamReader(new FileInputStream(machineIdFile));){
                    systemId = new BufferedReader(reader).lines().collect(Collectors.joining("\n"));
                }
                catch (IOException e) {
                    log.warnf((Throwable)e, "/etc/machine-id exists and is readable, but exception was raised when reading it", new Object[0]);
                    systemId = "";
                }
            } else {
                log.warnf("/etc/machine-id does not exist or is unreadable", new Object[0]);
                systemId = "";
            }
        }
        return systemId.isEmpty() ? null : systemId;
    }

    static {
        try {
            mapper = new ObjectMapper();
            mapper.setVisibilityChecker((VisibilityChecker<?>)mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
            InventoryJacksonConfig.configure(mapper);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

