/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.File;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.AbstractFilePersistenceResource;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ExposedByteArrayOutputStream;
import org.jboss.as.controller.persistence.FilePersistenceUtils;
import org.jboss.dmr.ModelNode;

public class ConfigurationFilePersistenceResource
extends AbstractFilePersistenceResource {
    private final ConfigurationFile configurationFile;
    protected final File fileName;

    ConfigurationFilePersistenceResource(ModelNode model, ConfigurationFile configurationFile, AbstractConfigurationPersister persister) throws ConfigurationPersistenceException {
        super(model, persister);
        this.configurationFile = configurationFile;
        this.fileName = configurationFile.getMainFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCommit(ExposedByteArrayOutputStream marshalled) {
        File tempFileName = FilePersistenceUtils.createTempFile(this.fileName);
        try {
            try {
                FilePersistenceUtils.writeToTempFile(marshalled, tempFileName, this.fileName);
            }
            catch (Exception e) {
                ControllerLogger.MGMT_OP_LOGGER.failedToStoreConfiguration(e, this.fileName.getName());
                if (tempFileName.exists() && !tempFileName.delete()) {
                    ControllerLogger.MGMT_OP_LOGGER.cannotDeleteTempFile(tempFileName.getName());
                    tempFileName.deleteOnExit();
                }
                return;
            }
            try {
                this.configurationFile.backup();
            }
            finally {
                this.configurationFile.commitTempFile(tempFileName);
            }
            this.configurationFile.fileWritten();
        }
        catch (ConfigurationPersistenceException e) {
            ControllerLogger.MGMT_OP_LOGGER.errorf((Throwable)e, e.toString(), new Object[0]);
        }
        finally {
            if (tempFileName.exists() && !tempFileName.delete()) {
                ControllerLogger.MGMT_OP_LOGGER.cannotDeleteTempFile(tempFileName.getName());
                tempFileName.deleteOnExit();
            }
        }
    }
}

