/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;

abstract class DeploymentContent {
    DeploymentContent() {
    }

    abstract void addContentToOperation(OperationBuilder var1, ModelNode var2);

    String resolvedName() {
        return null;
    }

    static DeploymentContent of(final Path content) {
        return new DeploymentContent(){

            @Override
            void addContentToOperation(OperationBuilder builder, ModelNode op) {
                ModelNode contentNode = op.get("content");
                ModelNode contentItem = contentNode.get(0);
                if (Files.isDirectory(content, new LinkOption[0])) {
                    contentItem.get("path").set(content.toAbsolutePath().toString());
                    contentItem.get("archive").set(false);
                } else {
                    contentItem.get("input-stream-index").set(builder.getInputStreamCount());
                    builder.addFileAsAttachment(content.toFile());
                }
            }

            @Override
            String resolvedName() {
                return content.getFileName().toString();
            }

            public String toString() {
                return String.format("%s(%s)", DeploymentContent.class.getName(), content);
            }
        };
    }

    static DeploymentContent of(InputStream content) {
        final ByteArrayInputStream copiedContent = DeploymentContent.copy(content);
        return new DeploymentContent(){

            @Override
            void addContentToOperation(OperationBuilder builder, ModelNode op) {
                copiedContent.reset();
                ModelNode contentNode = op.get("content");
                ModelNode contentItem = contentNode.get(0);
                contentItem.get("input-stream-index").set(builder.getInputStreamCount());
                builder.addInputStream(copiedContent);
            }

            public String toString() {
                return String.format("%s(%s)", DeploymentContent.class.getName(), copiedContent);
            }
        };
    }

    static DeploymentContent of(final URL url) {
        return new DeploymentContent(){

            @Override
            void addContentToOperation(OperationBuilder builder, ModelNode op) {
                ModelNode contentNode = op.get("content");
                ModelNode contentItem = contentNode.get(0);
                contentItem.get("url").set(url.toExternalForm());
            }

            @Override
            String resolvedName() {
                String path = url.getPath();
                int index = path.lastIndexOf(47);
                if (index >= 0) {
                    return path.substring(index + 1);
                }
                return path;
            }

            public String toString() {
                return String.format("%s(%s)", DeploymentContent.class.getName(), url.toExternalForm());
            }
        };
    }

    private static ByteArrayInputStream copy(InputStream in) {
        ByteArrayOutputStream copy = new ByteArrayOutputStream();
        byte[] buffer = new byte[64];
        try {
            int len;
            while ((len = in.read(buffer)) > 0) {
                copy.write(buffer, 0, len);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(copy.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy input stream.", e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }
}

