/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.NetworkIF;
import oshi.hardware.Networks;
import oshi.json.NullAwareJsonObjectBuilder;

public abstract class AbstractNetworks
implements Networks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNetworks.class);
    private JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);

    @Override
    public NetworkIF[] getNetworks() {
        ArrayList<NetworkIF> result = new ArrayList<NetworkIF>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(interfaces)) {
                if (netint.isLoopback() || netint.getHardwareAddress() == null) continue;
                NetworkIF netIF = new NetworkIF();
                netIF.setNetworkInterface(netint);
                this.updateNetworkStats(netIF);
                result.add(netIF);
            }
        }
        catch (SocketException ex) {
            LOG.error("Socket exception when retrieving network interfaces: " + ex.getMessage());
        }
        return result.toArray(new NetworkIF[result.size()]);
    }

    @Override
    public JsonObject toJSON() {
        JsonArrayBuilder netArray = this.jsonFactory.createArrayBuilder();
        for (NetworkIF store : this.getNetworks()) {
            netArray.add(store.toJSON());
        }
        return NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder()).add("networks", netArray).build();
    }
}

