/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import oshi.hardware.UsbDevice;
import oshi.json.NullAwareJsonObjectBuilder;

public abstract class AbstractUsbDevice
implements UsbDevice {
    private static final long serialVersionUID = 2L;
    protected String name;
    protected String vendor;
    protected String vendorId;
    protected String productId;
    protected String serialNumber;
    protected UsbDevice[] connectedDevices;
    private JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);

    public AbstractUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, UsbDevice[] connectedDevices) {
        this.name = name;
        this.vendor = vendor;
        this.vendorId = vendorId;
        this.productId = productId;
        this.serialNumber = serialNumber;
        this.connectedDevices = connectedDevices;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public String getVendorId() {
        return this.vendorId;
    }

    @Override
    public String getProductId() {
        return this.productId;
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public UsbDevice[] getConnectedDevices() {
        return this.connectedDevices;
    }

    @Override
    public JsonObject toJSON() {
        JsonArrayBuilder usbDeviceArrayBuilder = this.jsonFactory.createArrayBuilder();
        for (UsbDevice usbDevice : this.getConnectedDevices()) {
            usbDeviceArrayBuilder.add(usbDevice.toJSON());
        }
        return NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder()).add("name", this.getName()).add("vendor", this.getVendor()).add("vendorId", this.getVendorId()).add("productId", this.getProductId()).add("serialNumber", this.getSerialNumber()).add("connectedDevices", usbDeviceArrayBuilder.build()).build();
    }

    @Override
    public int compareTo(UsbDevice usb) {
        return this.getName().compareTo(usb.getName());
    }

    public String toString() {
        return AbstractUsbDevice.indentUsb(this, 1);
    }

    private static String indentUsb(UsbDevice usbDevice, int indent) {
        String indentFmt = indent > 2 ? String.format("%%%ds|-- ", indent - 4) : String.format("%%%ds", indent);
        StringBuilder sb = new StringBuilder(String.format(indentFmt, ""));
        sb.append(usbDevice.getName());
        if (usbDevice.getVendor().length() > 0) {
            sb.append(" (").append(usbDevice.getVendor()).append(")");
        }
        if (usbDevice.getSerialNumber().length() > 0) {
            sb.append(" [s/n: ").append(usbDevice.getSerialNumber()).append("]");
        }
        for (UsbDevice connected : usbDevice.getConnectedDevices()) {
            sb.append("\n").append(AbstractUsbDevice.indentUsb(connected, indent + 4));
        }
        return sb.toString();
    }
}

