/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.List;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

public class LinuxGlobalMemory
extends AbstractGlobalMemory {
    private static final long serialVersionUID = 1L;
    private long memFree = 0L;
    private long activeFile = 0L;
    private long inactiveFile = 0L;
    private long sReclaimable = 0L;
    private long swapFree = 0L;
    private long lastUpdate = 0L;

    @Override
    protected void updateMeminfo() {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate > 100L) {
            List<String> memInfo = null;
            memInfo = FileUtil.readFile("/proc/meminfo");
            if (memInfo.isEmpty()) {
                return;
            }
            boolean found = false;
            for (String checkLine : memInfo) {
                String[] memorySplit = checkLine.split("\\s+");
                if (memorySplit.length <= 1) continue;
                switch (memorySplit[0]) {
                    case "MemTotal:": {
                        this.memTotal = this.parseMeminfo(memorySplit);
                        break;
                    }
                    case "MemFree:": {
                        this.memFree = this.parseMeminfo(memorySplit);
                        break;
                    }
                    case "MemAvailable:": {
                        this.memAvailable = this.parseMeminfo(memorySplit);
                        found = true;
                        break;
                    }
                    case "Active(file):": {
                        this.activeFile = this.parseMeminfo(memorySplit);
                        break;
                    }
                    case "Inactive(file):": {
                        this.inactiveFile = this.parseMeminfo(memorySplit);
                        break;
                    }
                    case "SReclaimable:": {
                        this.sReclaimable = this.parseMeminfo(memorySplit);
                        break;
                    }
                    case "SwapTotal:": {
                        this.swapTotal = this.parseMeminfo(memorySplit);
                        break;
                    }
                    case "SwapFree:": {
                        this.swapFree = this.parseMeminfo(memorySplit);
                        break;
                    }
                }
            }
            this.swapUsed = this.swapTotal - this.swapFree;
            if (!found) {
                this.memAvailable = this.memFree + this.activeFile + this.inactiveFile + this.sReclaimable;
            }
            this.lastUpdate = now;
        }
    }

    @Override
    protected void updateSwap() {
        this.updateMeminfo();
    }

    private long parseMeminfo(String[] memorySplit) {
        if (memorySplit.length < 2) {
            return 0L;
        }
        long memory = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
        if (memorySplit.length > 2 && memorySplit[2].equals("kB")) {
            memory *= 1024L;
        }
        return memory;
    }
}

