/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.mac.IOKit;
import oshi.jna.platform.mac.SystemB;
import oshi.software.os.OSProcess;
import oshi.software.os.mac.MacProcess;
import oshi.util.FormatUtil;
import oshi.util.platform.mac.IOKitUtil;
import oshi.util.platform.mac.SysctlUtil;

public class MacCentralProcessor
extends AbstractCentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MacCentralProcessor.class);
    private int maxProc = 1024;

    public MacCentralProcessor() {
        this.initVars();
        this.initTicks();
        this.maxProc = SysctlUtil.sysctl("kern.maxproc", 4096);
        LOG.debug("Initialized Processor");
    }

    private void initVars() {
        this.setVendor(SysctlUtil.sysctl("machdep.cpu.vendor", ""));
        this.setName(SysctlUtil.sysctl("machdep.cpu.brand_string", ""));
        this.setCpu64(SysctlUtil.sysctl("hw.cpu64bit_capable", 0) != 0);
        int i = SysctlUtil.sysctl("machdep.cpu.stepping", -1);
        this.setStepping(i < 0 ? "" : Integer.toString(i));
        i = SysctlUtil.sysctl("machdep.cpu.model", -1);
        this.setModel(i < 0 ? "" : Integer.toString(i));
        i = SysctlUtil.sysctl("machdep.cpu.family", -1);
        this.setFamily(i < 0 ? "" : Integer.toString(i));
    }

    @Override
    protected void calculateProcessorCounts() {
        this.logicalProcessorCount = SysctlUtil.sysctl("hw.logicalcpu", 1);
        this.physicalProcessorCount = SysctlUtil.sysctl("hw.physicalcpu", 1);
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        SystemB.HostCpuLoadInfo cpuLoadInfo;
        long[] ticks = new long[this.curTicks.length];
        int machPort = SystemB.INSTANCE.mach_host_self();
        if (0 != SystemB.INSTANCE.host_statistics(machPort, 3, cpuLoadInfo = new SystemB.HostCpuLoadInfo(), new IntByReference(cpuLoadInfo.size()))) {
            LOG.error("Failed to get System CPU ticks. Error code: " + Native.getLastError());
            return ticks;
        }
        ticks[0] = cpuLoadInfo.cpu_ticks[0];
        ticks[1] = cpuLoadInfo.cpu_ticks[3];
        ticks[2] = cpuLoadInfo.cpu_ticks[1];
        ticks[3] = cpuLoadInfo.cpu_ticks[2];
        return ticks;
    }

    @Override
    public long getSystemIOWaitTicks() {
        return 0L;
    }

    @Override
    public long[] getSystemIrqTicks() {
        return new long[2];
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        double[] average;
        int retval;
        if (nelem < 1) {
            throw new IllegalArgumentException("Must include at least one element.");
        }
        if (nelem > 3) {
            LOG.warn("Max elements of SystemLoadAverage is 3. " + nelem + " specified. Ignoring extra.");
            nelem = 3;
        }
        if ((retval = SystemB.INSTANCE.getloadavg(average = new double[nelem], nelem)) < nelem) {
            for (int i = Math.max(retval, 0); i < average.length; ++i) {
                average[i] = -1.0;
            }
        }
        return average;
    }

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        IntByReference procInfoCount;
        PointerByReference procCpuLoadInfo;
        IntByReference procCount;
        long[][] ticks = new long[this.logicalProcessorCount][4];
        int machPort = SystemB.INSTANCE.mach_host_self();
        if (0 != SystemB.INSTANCE.host_processor_info(machPort, 2, procCount = new IntByReference(), procCpuLoadInfo = new PointerByReference(), procInfoCount = new IntByReference())) {
            LOG.error("Failed to update CPU Load. Error code: " + Native.getLastError());
            return ticks;
        }
        int[] cpuTicks = procCpuLoadInfo.getValue().getIntArray(0L, procInfoCount.getValue());
        for (int cpu = 0; cpu < procCount.getValue(); ++cpu) {
            for (int j = 0; j < 4; ++j) {
                int offset = cpu * 4;
                ticks[cpu][0] = FormatUtil.getUnsignedInt(cpuTicks[offset + 0]);
                ticks[cpu][1] = FormatUtil.getUnsignedInt(cpuTicks[offset + 3]);
                ticks[cpu][2] = FormatUtil.getUnsignedInt(cpuTicks[offset + 1]);
                ticks[cpu][3] = FormatUtil.getUnsignedInt(cpuTicks[offset + 2]);
            }
        }
        return ticks;
    }

    @Override
    public long getSystemUptime() {
        SystemB.Timeval tv = new SystemB.Timeval();
        if (!SysctlUtil.sysctl("kern.boottime", tv)) {
            return 0L;
        }
        return System.currentTimeMillis() / 1000L - (long)tv.tv_sec;
    }

    @Override
    public String getSystemSerialNumber() {
        if (this.cpuSerialNumber == null) {
            int service = IOKitUtil.getMatchingService("IOPlatformExpertDevice");
            if (service != 0) {
                this.cpuSerialNumber = IOKitUtil.getIORegistryStringProperty(service, "IOPlatformSerialNumber");
                IOKit.INSTANCE.IOObjectRelease(service);
            }
            if (this.cpuSerialNumber == null) {
                this.cpuSerialNumber = "unknown";
            }
        }
        return this.cpuSerialNumber;
    }

    @Override
    public OSProcess[] getProcesses() {
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        int[] pids = new int[this.maxProc];
        int numberOfProcesses = SystemB.INSTANCE.proc_listpids(1, 0, pids, pids.length) / SystemB.INT_SIZE;
        for (int i = 0; i < numberOfProcesses; ++i) {
            OSProcess proc = this.getProcess(pids[i]);
            if (proc == null) continue;
            procs.add(proc);
        }
        return procs.toArray(new OSProcess[procs.size()]);
    }

    @Override
    public OSProcess getProcess(int pid) {
        String[] pathSplit;
        SystemB.ProcTaskAllInfo taskAllInfo = new SystemB.ProcTaskAllInfo();
        if (0 > SystemB.INSTANCE.proc_pidinfo(pid, 2, 0L, taskAllInfo, taskAllInfo.size())) {
            return null;
        }
        String name = null;
        String path = "";
        Memory buf = new Memory(4096L);
        if (0 < SystemB.INSTANCE.proc_pidpath(pid, buf, 4096) && (pathSplit = (path = buf.getString(0L).trim()).split("/")).length > 0) {
            name = pathSplit[pathSplit.length - 1];
        }
        if (taskAllInfo.ptinfo.pti_threadnum < 1) {
            return null;
        }
        if (name == null) {
            for (int t = 0; t < taskAllInfo.pbsd.pbi_comm.length; ++t) {
                if (taskAllInfo.pbsd.pbi_comm[t] != 0) continue;
                name = new String(taskAllInfo.pbsd.pbi_comm, 0, t);
                break;
            }
        }
        return new MacProcess(name, path, taskAllInfo.pbsd.pbi_status, pid, taskAllInfo.pbsd.pbi_ppid, taskAllInfo.ptinfo.pti_threadnum, taskAllInfo.ptinfo.pti_priority, taskAllInfo.ptinfo.pti_virtual_size, taskAllInfo.ptinfo.pti_resident_size, taskAllInfo.ptinfo.pti_total_system / 1000000L, taskAllInfo.ptinfo.pti_total_user / 1000000L, taskAllInfo.pbsd.pbi_start_tvsec * 1000L + taskAllInfo.pbsd.pbi_start_tvusec / 1000L, System.currentTimeMillis());
    }

    @Override
    public int getProcessId() {
        return SystemB.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return SystemB.INSTANCE.proc_listpids(1, 0, null, 0) / SystemB.INT_SIZE;
    }

    @Override
    public int getThreadCount() {
        int[] pids = new int[this.getProcessCount() + 10];
        int numberOfProcesses = SystemB.INSTANCE.proc_listpids(1, 0, pids, pids.length) / SystemB.INT_SIZE;
        int numberOfThreads = 0;
        SystemB.ProcTaskInfo taskInfo = new SystemB.ProcTaskInfo();
        for (int i = 0; i < numberOfProcesses; ++i) {
            SystemB.INSTANCE.proc_pidinfo(pids[i], 4, 0L, taskInfo, taskInfo.size());
            numberOfThreads += taskInfo.pti_threadnum;
        }
        return numberOfThreads;
    }
}

