/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworks;
import oshi.jna.platform.mac.SystemB;

public class MacNetworks
extends AbstractNetworks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MacNetworks.class);
    private static int CTL_NET = 4;
    private static int PF_ROUTE = 17;
    private static int NET_RT_IFLIST2 = 6;
    private static int RTM_IFINFO2 = 18;
    private Map<Integer, IFdata> ifMap = new HashMap<Integer, IFdata>();
    private long lastIFmapTime = 0L;

    private void mapIFs() {
        SystemB.IFmsgHdr ifm;
        long now = System.currentTimeMillis();
        if (now - this.lastIFmapTime < 200L) {
            return;
        }
        this.lastIFmapTime = now;
        int[] mib = new int[]{CTL_NET, PF_ROUTE, 0, 0, NET_RT_IFLIST2, 0};
        IntByReference len = new IntByReference();
        if (0 != SystemB.INSTANCE.sysctl(mib, 6, null, len, null, 0)) {
            LOG.error("Didn't get buffer length for IFLIST2");
            return;
        }
        Memory buf = new Memory(len.getValue());
        if (0 != SystemB.INSTANCE.sysctl(mib, 6, buf, len, null, 0)) {
            LOG.error("Didn't get buffer for IFLIST2");
            return;
        }
        this.ifMap.clear();
        int lim = len.getValue();
        for (int next = 0; next < lim; next += ifm.ifm_msglen) {
            Pointer p = new Pointer(Pointer.nativeValue(buf) + (long)next);
            ifm = new SystemB.IFmsgHdr(p);
            ifm.read();
            if (ifm.ifm_type != RTM_IFINFO2) continue;
            SystemB.IFmsgHdr2 if2m = new SystemB.IFmsgHdr2(p);
            if2m.read();
            this.ifMap.put(Integer.valueOf(if2m.ifm_index), new IFdata(if2m.ifm_data.ifi_opackets, if2m.ifm_data.ifi_ipackets, if2m.ifm_data.ifi_obytes, if2m.ifm_data.ifi_ibytes, if2m.ifm_data.ifi_baudrate));
        }
    }

    @Override
    public void updateNetworkStats(NetworkIF netIF) {
        this.mapIFs();
        Integer index = netIF.getNetworkInterface().getIndex();
        IFdata ifData = this.ifMap.get(index);
        if (ifData != null) {
            netIF.setBytesSent(ifData.oBytes);
            netIF.setBytesRecv(ifData.iBytes);
            netIF.setPacketsSent(ifData.oPackets);
            netIF.setPacketsRecv(ifData.iPackets);
            netIF.setSpeed(ifData.speed);
        }
    }

    private static class IFdata {
        long oPackets;
        long iPackets;
        long oBytes;
        long iBytes;
        long speed;

        IFdata(long oPackets, long iPackets, long oBytes, long iBytes, long speed) {
            this.oPackets = oPackets;
            this.iPackets = iPackets;
            this.oBytes = oBytes;
            this.iBytes = iBytes;
            this.speed = speed;
        }
    }
}

