/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.cmd;

import java.util.Map;
import org.hawkular.agent.javaagent.JavaAgentEngine;
import org.hawkular.agent.javaagent.config.Configuration;
import org.hawkular.agent.javaagent.config.DMRAvail;
import org.hawkular.agent.javaagent.config.DMRAvailSet;
import org.hawkular.agent.javaagent.config.DMRMetric;
import org.hawkular.agent.javaagent.config.DMRMetricSet;
import org.hawkular.agent.javaagent.config.JMXAvail;
import org.hawkular.agent.javaagent.config.JMXAvailSet;
import org.hawkular.agent.javaagent.config.JMXMetric;
import org.hawkular.agent.javaagent.config.JMXMetricSet;
import org.hawkular.agent.javaagent.config.TimeUnits;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.agent.javaagent.log.JavaAgentLoggers;
import org.hawkular.agent.javaagent.log.MsgLogger;
import org.hawkular.agent.monitor.cmd.AbstractJMXResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;
import org.hawkular.agent.monitor.protocol.jmx.JMXSession;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.UpdateCollectionIntervalsRequest;
import org.hawkular.cmdgw.api.UpdateCollectionIntervalsResponse;

public class UpdateCollectionIntervalsCommand
extends AbstractJMXResourcePathCommand<UpdateCollectionIntervalsRequest, UpdateCollectionIntervalsResponse> {
    private static final MsgLogger log = JavaAgentLoggers.getLogger(UpdateCollectionIntervalsCommand.class);
    public static final Class<UpdateCollectionIntervalsRequest> REQUEST_CLASS = UpdateCollectionIntervalsRequest.class;

    public UpdateCollectionIntervalsCommand() {
        super("Update Collection Intervals", "Agent[JMX]");
    }

    @Override
    protected UpdateCollectionIntervalsResponse createResponse() {
        return new UpdateCollectionIntervalsResponse();
    }

    @Override
    protected BinaryData execute(EndpointService<JMXNodeLocation, JMXSession> endpointService, String resourceId, BasicMessageWithExtraData<UpdateCollectionIntervalsRequest> envelope, UpdateCollectionIntervalsResponse response, CommandContext context) throws Exception {
        String[] names;
        final JavaAgentEngine javaAgent = (JavaAgentEngine)context.getAgentCoreEngine();
        final Configuration javaAgentConfig = javaAgent.getConfigurationManager().getConfiguration();
        UpdateCollectionIntervalsRequest request = envelope.getBasicMessage();
        Map<String, String> metricTypes = request.getMetricTypes();
        Map<String, String> availTypes = request.getAvailTypes();
        boolean requireRestart = false;
        if (metricTypes != null && !metricTypes.isEmpty()) {
            block0: for (Map.Entry<String, String> entry : metricTypes.entrySet()) {
                String metricTypeId = entry.getKey();
                names = this.parseMetricTypeId(metricTypeId);
                String metricSetName = names[0];
                String metricName = names[1];
                for (Validatable validatable : javaAgentConfig.getDmrMetricSets()) {
                    if (!metricSetName.equals(((DMRMetricSet)validatable).getName())) continue;
                    for (Validatable validatable2 : ((DMRMetricSet)validatable).getDmrMetrics()) {
                        if (!metricName.equals(((DMRMetric)validatable2).getName())) continue;
                        ((DMRMetric)validatable2).setInterval(Integer.valueOf(entry.getValue()));
                        ((DMRMetric)validatable2).setTimeUnits(TimeUnits.seconds);
                        requireRestart = true;
                        continue block0;
                    }
                }
                for (Validatable validatable : javaAgentConfig.getJmxMetricSets()) {
                    if (!metricSetName.equals(((JMXMetricSet)validatable).getName())) continue;
                    for (Validatable validatable3 : ((JMXMetricSet)validatable).getJmxMetrics()) {
                        if (!metricName.equals(((JMXMetric)validatable3).getName())) continue;
                        ((JMXMetric)validatable3).setInterval(Integer.valueOf(entry.getValue()));
                        ((JMXMetric)validatable3).setTimeUnits(TimeUnits.seconds);
                        requireRestart = true;
                        continue block0;
                    }
                }
            }
        }
        if (availTypes != null && !availTypes.isEmpty()) {
            block5: for (Map.Entry<String, String> entry : availTypes.entrySet()) {
                String availTypeId = entry.getKey();
                names = this.parseAvailTypeId(availTypeId);
                String availSetName = names[0];
                String availName = names[1];
                for (Validatable validatable : javaAgentConfig.getDmrAvailSets()) {
                    if (!availSetName.equals(((DMRAvailSet)validatable).getName())) continue;
                    for (Validatable validatable4 : ((DMRAvailSet)validatable).getDmrAvails()) {
                        if (!availName.equals(((DMRAvail)validatable4).getName())) continue;
                        ((DMRAvail)validatable4).setInterval(Integer.valueOf(entry.getValue()));
                        ((DMRAvail)validatable4).setTimeUnits(TimeUnits.seconds);
                        requireRestart = true;
                        continue block5;
                    }
                }
                for (Validatable validatable : javaAgentConfig.getJmxAvailSets()) {
                    if (!availSetName.equals(((JMXAvailSet)validatable).getName())) continue;
                    for (Validatable validatable5 : ((JMXAvailSet)validatable).getJmxAvails()) {
                        if (!availName.equals(((JMXAvail)validatable5).getName())) continue;
                        ((JMXAvail)validatable5).setInterval(Integer.valueOf(entry.getValue()));
                        ((JMXAvail)validatable5).setTimeUnits(TimeUnits.seconds);
                        requireRestart = true;
                        continue block5;
                    }
                }
            }
        }
        if (requireRestart) {
            context.addResponseSentListener(new CommandContext.ResponseSentListener(){

                @Override
                public void onSend(BasicMessageWithExtraData<? extends BasicMessage> response, Exception sendError) {
                    log.info("Collection intervals updated. Persisting changes and restarting agent.");
                    javaAgent.stopHawkularAgent();
                    javaAgent.startHawkularAgent(javaAgentConfig);
                }
            });
        } else {
            log.debug("Skipping collection interval update, no valid type updates provided.");
        }
        return null;
    }

    @Override
    protected void validate(BasicMessageWithExtraData<UpdateCollectionIntervalsRequest> envelope, MonitoredEndpoint<? extends AgentCoreEngineConfiguration.AbstractEndpointConfiguration> endpoint) {
    }

    private String[] parseMetricTypeId(String metricTypeId) {
        String[] names = metricTypeId.split("~");
        if (names.length != 2) {
            throw new IllegalArgumentException("MetricTypeId must be of form MetricTypeSetName~MetricTypeName: " + metricTypeId);
        }
        return names;
    }

    private String[] parseAvailTypeId(String availTypeId) {
        String[] names = availTypeId.split("~");
        if (names.length != 2) {
            throw new IllegalArgumentException("AvailTypeId must be of form AvailTypeSetName~AvailTypeName: " + availTypeId);
        }
        return names;
    }
}

