/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.client.api.NotificationType;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class DMRNotification
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    private NotificationType notificationType;

    public DMRNotification() {
    }

    public DMRNotification(DMRNotification original) {
        this.name = original.name;
        this.notificationType = original.notificationType;
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("notification-dmr name must be specified");
        }
        try {
            this.notificationType = NotificationType.valueOf(this.name.trim().replace("-", "_").toUpperCase());
        }
        catch (Exception e) {
            throw new Exception("notification-dmr name [" + this.name + "] is an unknown notification type");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NotificationType getNotificationType() {
        if (this.notificationType == null) {
            throw new IllegalStateException("Notification type is null - validate was never called. This is a bug.");
        }
        return this.notificationType;
    }
}

