/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.DMRNotification;
import org.hawkular.agent.javaagent.config.DMROperation;
import org.hawkular.agent.javaagent.config.DMRResourceConfig;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class DMRResourceType
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty
    private String path = "/";
    @JsonProperty(value="resource-name-template", required=true)
    private String resourceNameTemplate;
    @JsonProperty
    private String[] parents;
    @JsonProperty(value="metric-sets")
    private String[] metricSets;
    @JsonProperty(value="avail-sets")
    private String[] availSets;
    @JsonProperty(value="notification-dmr")
    private DMRNotification[] dmrNotifications;
    @JsonProperty(value="resource-config-dmr")
    private DMRResourceConfig[] dmrResourceConfigs;
    @JsonProperty(value="operation-dmr")
    private DMROperation[] dmrOperations;

    public DMRResourceType() {
    }

    public DMRResourceType(DMRResourceType original) {
        this.name = original.name;
        this.path = original.path;
        this.resourceNameTemplate = original.resourceNameTemplate;
        this.parents = original.parents == null ? null : Arrays.copyOf(original.parents, original.parents.length);
        this.metricSets = original.metricSets == null ? null : Arrays.copyOf(original.metricSets, original.metricSets.length);
        this.availSets = original.availSets == null ? null : Arrays.copyOf(original.availSets, original.availSets.length);
        this.dmrNotifications = original.dmrNotifications == null ? null : Arrays.copyOf(original.dmrNotifications, original.dmrNotifications.length);
        this.dmrResourceConfigs = Util.cloneArray(original.dmrResourceConfigs);
        this.dmrOperations = Util.cloneArray(original.dmrOperations);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("resource-type-dmr name must be specified");
        }
        try {
            if (!"/".equals(this.path)) {
                WildflyCompatibilityUtils.parseCLIStyleAddress(this.path);
            }
        }
        catch (Exception e) {
            throw new Exception("resource-type-dmr [" + this.name + "] path [" + this.path + "] is invalid", e);
        }
        if (this.dmrResourceConfigs != null) {
            for (Validatable validatable : this.dmrResourceConfigs) {
                ((DMRResourceConfig)validatable).validate();
            }
        }
        if (this.dmrOperations != null) {
            for (Validatable validatable : this.dmrOperations) {
                ((DMROperation)validatable).validate();
            }
        }
        if (this.dmrNotifications != null) {
            for (Validatable validatable : this.dmrNotifications) {
                ((DMRNotification)validatable).validate();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getResourceNameTemplate() {
        return this.resourceNameTemplate;
    }

    public void setResourceNameTemplate(String resourceNameTemplate) {
        this.resourceNameTemplate = resourceNameTemplate;
    }

    public String[] getParents() {
        return this.parents;
    }

    public void setParents(String[] parents) {
        this.parents = parents;
    }

    public String[] getMetricSets() {
        return this.metricSets;
    }

    public void setMetricSets(String[] metricSets) {
        this.metricSets = metricSets;
    }

    public String[] getAvailSets() {
        return this.availSets;
    }

    public void setAvailSets(String[] availSets) {
        this.availSets = availSets;
    }

    public DMRResourceConfig[] getDmrResourceConfigs() {
        return this.dmrResourceConfigs;
    }

    public void setDmrResourceConfigs(DMRResourceConfig[] dmrResourceConfigs) {
        this.dmrResourceConfigs = dmrResourceConfigs;
    }

    public DMROperation[] getDmrOperations() {
        return this.dmrOperations;
    }

    public void setDmrOperations(DMROperation[] dmrOperations) {
        this.dmrOperations = dmrOperations;
    }

    public DMRNotification[] getDmrNotifications() {
        return this.dmrNotifications;
    }

    public void setDmrNotifications(DMRNotification[] dmrNotifications) {
        this.dmrNotifications = dmrNotifications;
    }
}

