/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;

@ApiModel(description="A metadata pack can incorporate global resource and metric types making them read-only.", parent=Entity.class)
public final class MetadataPack
extends Entity {
    public static final SegmentType SEGMENT_TYPE = SegmentType.mp;

    public static boolean canIncorporate(CanonicalPath entityPath) {
        SegmentType entityType = entityPath.getSegment().getElementType();
        SegmentType parentType = entityPath.up().getSegment().getElementType();
        return SegmentType.t.equals((Object)parentType) && (SegmentType.rt.equals((Object)entityType) || SegmentType.mt.equals((Object)entityType));
    }

    public MetadataPack(String name, CanonicalPath path, Map<String, Object> properties) {
        super(name, path, properties);
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitMetadataPack(this, parameter);
    }

    @ApiModel(value="MetadataPackBlueprint")
    public static final class Blueprint
    extends AbstractElement.Blueprint {
        private final Set<CanonicalPath> members;
        private final String name;

        public static Builder builder() {
            return new Builder();
        }

        public Blueprint(String name, Set<CanonicalPath> members, Map<String, Object> properties) {
            super(properties);
            this.name = name;
            members.forEach(p -> {
                if (!MetadataPack.canIncorporate(p)) {
                    throw new IllegalArgumentException("Entity on path '" + p + "' cannot be part of a metadata pack.");
                }
            });
            this.members = Collections.unmodifiableSet(new HashSet<CanonicalPath>(members));
        }

        public String getName() {
            return this.name;
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitMetadataPack(this, parameter);
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            private final Set<CanonicalPath> members = new HashSet<CanonicalPath>();
            private String name;

            @Override
            public Builder withName(String name) {
                this.name = name;
                return this;
            }

            @Override
            public Blueprint build() {
                return new Blueprint(this.name, this.members, this.properties);
            }
        }
    }
}

