/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.SegmentType;

public final class DetypedPathDeserializer
extends JsonDeserializer<Path> {
    private static ThreadLocal<CanonicalPath> CURRENT_CANONICAL_ORIGIN = new ThreadLocal();
    private static final ThreadLocal<CanonicalPath> CURRENT_RELATIVE_PATH_ORIGIN = new ThreadLocal();
    private static final ThreadLocal<Class<?>> CURRENT_ENTITY_TYPE = new ThreadLocal();

    public static void setCurrentCanonicalOrigin(CanonicalPath path) {
        CURRENT_CANONICAL_ORIGIN.set(path);
    }

    public static void setCurrentRelativePathOrigin(CanonicalPath path) {
        CURRENT_RELATIVE_PATH_ORIGIN.set(path);
    }

    public static void setCurrentEntityType(Class<?> entityType) {
        CURRENT_ENTITY_TYPE.set(entityType);
    }

    @Override
    public Path deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String str = jp.getValueAsString();
        CanonicalPath co = CURRENT_CANONICAL_ORIGIN.get();
        CanonicalPath ro = CURRENT_RELATIVE_PATH_ORIGIN.get();
        Class<?> entityType = CURRENT_ENTITY_TYPE.get();
        return Path.fromPartiallyUntypedString(str, co, ro, this.getIntendedFinalType(entityType));
    }

    private SegmentType getIntendedFinalType(Class<?> type) {
        if (type == null) {
            return null;
        }
        try {
            return AbstractElement.segmentTypeFromType(type);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return null;
        }
    }
}

