/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public abstract class AbstractRemoveStepHandler
implements OperationStepHandler {
    private final Set<RuntimeCapability> capabilities;

    protected AbstractRemoveStepHandler() {
        this(AbstractAddStepHandler.NULL_CAPABILITIES);
    }

    protected AbstractRemoveStepHandler(RuntimeCapability ... capabilities) {
        this((Set<RuntimeCapability>)(capabilities.length == 0 ? AbstractAddStepHandler.NULL_CAPABILITIES : new HashSet<RuntimeCapability>(Arrays.asList(capabilities))));
    }

    protected AbstractRemoveStepHandler(Set<RuntimeCapability> capabilities) {
        this.capabilities = capabilities == null ? AbstractAddStepHandler.NULL_CAPABILITIES : capabilities;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        final ModelNode model = Resource.Tools.readModel(resource);
        this.performRemove(context, operation, model);
        if (!AbstractRemoveStepHandler.hasResource(context)) {
            this.recordCapabilitiesAndRequirements(context, operation, resource);
            if (this.requiresRuntime(context)) {
                context.addStep(new OperationStepHandler(){

                    @Override
                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        AbstractRemoveStepHandler.this.performRuntime(context, operation, model);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            @Override
                            public void handleRollback(OperationContext context, ModelNode operation) {
                                try {
                                    AbstractRemoveStepHandler.this.recoverServices(context, operation, model);
                                }
                                catch (Exception e) {
                                    ControllerLogger.MGMT_OP_LOGGER.errorRevertingOperation(e, this.getClass().getSimpleName(), operation.require("operation").asString(), context.getCurrentAddress());
                                }
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        PathAddress address = context.getCurrentAddress();
        LinkedHashMap<PathAddress, OperationStepHandler> map = new LinkedHashMap<PathAddress, OperationStepHandler>();
        for (String string : resource.getChildTypes()) {
            for (Resource.ResourceEntry entry : resource.getChildren(string)) {
                OperationStepHandler childHandler;
                ImmutableManagementResourceRegistration mrr;
                PathElement path = entry.getPathElement();
                if (entry.isRuntime() || !this.removeChildRecursively(path) || (mrr = context.getResourceRegistration().getSubModel(PathAddress.pathAddress(path))).isRuntimeOnly() || mrr.isAlias() || (childHandler = mrr.getOperationHandler(PathAddress.EMPTY_ADDRESS, "remove")) == null) continue;
                PathAddress childAddress = address.append(path);
                map.put(childAddress, childHandler);
            }
        }
        if (map.isEmpty()) {
            context.removeResource(PathAddress.EMPTY_ADDRESS);
        } else {
            context.addStep(this, OperationContext.Stage.MODEL, true);
            for (Map.Entry entry : map.entrySet()) {
                PathAddress child = (PathAddress)entry.getKey();
                ControllerLogger.MGMT_OP_LOGGER.debugf("Adding remove step for child at %s", (Object)child);
                context.addStep(Util.createRemoveOperation(child), (OperationStepHandler)entry.getValue(), OperationContext.Stage.MODEL, true);
            }
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        Set<RuntimeCapability> capabilitySet = this.capabilities.isEmpty() ? context.getResourceRegistration().getCapabilities() : this.capabilities;
        for (RuntimeCapability capability : capabilitySet) {
            if (capability.isDynamicallyNamed()) {
                context.deregisterCapability(capability.getDynamicName(context.getCurrentAddressValue()));
                continue;
            }
            context.deregisterCapability(capability.getName());
        }
        ModelNode model = resource.getModel();
        ImmutableManagementResourceRegistration mrr = context.getResourceRegistration();
        for (String attr : mrr.getAttributeNames(PathAddress.EMPTY_ADDRESS)) {
            AttributeDefinition ad;
            AttributeAccess aa = mrr.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attr);
            if (aa == null || (ad = aa.getAttributeDefinition()) == null || !model.hasDefined(ad.getName()) && !ad.hasCapabilityRequirements()) continue;
            ad.removeCapabilityRequirements(context, model.get(ad.getName()));
        }
    }

    @Deprecated
    protected boolean requireNoChildResources() {
        return false;
    }

    protected boolean removeChildRecursively(PathElement child) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.isDefaultRequiresRuntime();
    }

    private static boolean hasResource(OperationContext context) {
        try {
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            return true;
        }
        catch (Resource.NoSuchResourceException nsre) {
            return false;
        }
    }
}

