/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.BlockingTimeout;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.remote.BlockingQueueOperationListener;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.remote.TransactionalProtocolHandlers;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public class RemoteProxyController
implements ProxyController {
    private final PathAddress pathAddress;
    private final ProxyOperationAddressTranslator addressTranslator;
    private final TransactionalProtocolClient client;
    private final ModelVersion targetKernelVersion;

    private RemoteProxyController(TransactionalProtocolClient client, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator, ModelVersion targetKernelVersion) {
        this.client = client;
        this.pathAddress = pathAddress;
        this.addressTranslator = addressTranslator;
        this.targetKernelVersion = targetKernelVersion;
    }

    public static RemoteProxyController create(TransactionalProtocolClient client, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator, ModelVersion targetKernelVersion) {
        return new RemoteProxyController(client, pathAddress, addressTranslator, targetKernelVersion);
    }

    @Deprecated
    public static RemoteProxyController create(ManagementChannelHandler channelAssociation, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator) {
        TransactionalProtocolClient client = TransactionalProtocolHandlers.createClient(channelAssociation);
        return RemoteProxyController.create(client, pathAddress, addressTranslator, ModelVersion.CURRENT);
    }

    public TransactionalProtocolClient getTransactionalProtocolClient() {
        return this.client;
    }

    @Override
    public PathAddress getProxyNodeAddress() {
        return this.pathAddress;
    }

    @Override
    public void execute(ModelNode original, OperationMessageHandler messageHandler, final ProxyController.ProxyOperationControl control, OperationAttachments attachments, final BlockingTimeout blockingTimeout) {
        final CountDownLatch completed = new CountDownLatch(1);
        final ArrayBlockingQueue queue = new ArrayBlockingQueue(1, true);
        TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation> operationListener = new TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation>(){

            @Override
            public void operationPrepared(TransactionalProtocolClient.PreparedOperation<TransactionalProtocolClient.Operation> prepared) {
                if (!queue.offer(prepared)) {
                    prepared.rollback();
                }
            }

            @Override
            public void operationFailed(TransactionalProtocolClient.Operation operation, ModelNode result) {
                try {
                    queue.offer(new BlockingQueueOperationListener.FailedOperation<TransactionalProtocolClient.Operation>(operation, result));
                }
                finally {
                    completed.countDown();
                }
            }

            @Override
            public void operationComplete(TransactionalProtocolClient.Operation operation, OperationResponse response) {
                try {
                    control.operationCompleted(response);
                }
                finally {
                    completed.countDown();
                }
            }
        };
        AsyncFuture<OperationResponse> futureResult = null;
        try {
            TransactionalProtocolClient.PreparedOperation prepared;
            final PathAddress targetAddress = PathAddress.pathAddress(original.get("address"));
            final ModelNode translated = this.translateOperationForProxy(original, targetAddress);
            ControllerLogger.MGMT_OP_LOGGER.tracef("Executing %s for %s", (Object)translated.get("operation").asString(), (Object)this.getProxyNodeAddress());
            futureResult = this.client.execute(operationListener, translated, messageHandler, attachments);
            if (blockingTimeout == null) {
                prepared = (TransactionalProtocolClient.PreparedOperation)queue.take();
            } else {
                long timeout = blockingTimeout.getProxyBlockingTimeout(targetAddress, this);
                prepared = (TransactionalProtocolClient.PreparedOperation)queue.poll(timeout, TimeUnit.MILLISECONDS);
                if (prepared == null) {
                    blockingTimeout.proxyTimeoutDetected(targetAddress);
                    futureResult.cancel(true);
                    ModelNode response = this.getTimeoutResponse(translated.get("operation").asString(), timeout);
                    control.operationFailed(response);
                    ControllerLogger.MGMT_OP_LOGGER.info(response.get("failure-description").asString());
                    return;
                }
            }
            if (prepared.isFailed()) {
                control.operationFailed(prepared.getPreparedResult());
                return;
            }
            final AsyncFuture<OperationResponse> cancellable = futureResult;
            control.operationPrepared(new ModelController.OperationTransaction(){

                @Override
                public void commit() {
                    prepared.commit();
                    this.awaitCompletion();
                }

                @Override
                public void rollback() {
                    prepared.rollback();
                    this.awaitCompletion();
                }

                private void awaitCompletion() {
                    try {
                        if (blockingTimeout == null) {
                            completed.await();
                        } else {
                            long timeout = blockingTimeout.getProxyBlockingTimeout(targetAddress, RemoteProxyController.this);
                            if (!completed.await(timeout, TimeUnit.MILLISECONDS)) {
                                cancellable.cancel(true);
                                blockingTimeout.proxyTimeoutDetected(targetAddress);
                                ControllerLogger.MGMT_OP_LOGGER.timeoutAwaitingFinalResponse(translated.get("operation").asString(), RemoteProxyController.this.getProxyNodeAddress(), timeout);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        cancellable.cancel(true);
                        ControllerLogger.MGMT_OP_LOGGER.interruptedAwaitingFinalResponse(translated.get("operation").asString(), RemoteProxyController.this.getProxyNodeAddress());
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, prepared.getPreparedResult());
        }
        catch (InterruptedException e) {
            if (futureResult != null) {
                ControllerLogger.MGMT_OP_LOGGER.interruptedAwaitingInitialResponse(original.get("operation").asString(), this.getProxyNodeAddress());
                futureResult.cancel(true);
            }
            control.operationFailed(RemoteProxyController.getCancelledResponse());
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            ModelNode result = new ModelNode();
            result.get("outcome").set("failed");
            result.get("failure-description").set(e.getLocalizedMessage());
            control.operationFailed(result);
        }
    }

    @Override
    public ModelVersion getKernelModelVersion() {
        return this.targetKernelVersion;
    }

    public ModelNode translateOperationForProxy(ModelNode op) {
        return this.translateOperationForProxy(op, PathAddress.pathAddress(op.get("address")));
    }

    private ModelNode translateOperationForProxy(ModelNode op, PathAddress targetAddress) {
        PathAddress translated = this.addressTranslator.translateAddress(targetAddress);
        if (targetAddress.equals(translated)) {
            return op;
        }
        ModelNode proxyOp = op.clone();
        proxyOp.get("address").set(translated.toModelNode());
        return proxyOp;
    }

    private static ModelNode getCancelledResponse() {
        ModelNode result = new ModelNode();
        result.get("outcome").set("cancelled");
        result.get("failure-description").set(ControllerLogger.ROOT_LOGGER.operationCancelled());
        return result;
    }

    private ModelNode getTimeoutResponse(String operation, long timeout) {
        ModelNode response = new ModelNode();
        response.get("outcome").set("failed");
        response.get("failure-description").set(ControllerLogger.ROOT_LOGGER.proxiedOperationTimedOut(operation, this.pathAddress, timeout));
        return response;
    }
}

