/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.services.path;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.AbsolutePathService;
import org.jboss.as.controller.services.path.AbstractPathService;
import org.jboss.as.controller.services.path.HardcodedPathResource;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.RelativePathService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public abstract class PathManagerService
implements PathManager,
Service<PathManager> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append("path", "manager");
    private final Map<String, PathEntry> pathEntries = new HashMap<String, PathEntry>();
    private final Map<String, Set<String>> dependenctRelativePaths = new HashMap<String, Set<String>>();
    private final Map<String, Map<PathManager.Event, Set<PathManager.Callback>>> callbacks = new HashMap<String, Map<PathManager.Event, Set<PathManager.Callback>>>();
    private final PathEntry.PathResolver absoluteResolver = new PathEntry.PathResolver(){

        @Override
        public String resolvePath(String name, String path, String relativeTo, PathEntry.PathResolver resolver) {
            return AbsolutePathService.convertPath(path);
        }

        @Override
        public boolean isResolved(String relativeTo) {
            return true;
        }
    };
    private final PathEntry.PathResolver relativeResolver = new PathEntry.PathResolver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String resolvePath(String name, String path, String relativeTo, PathEntry.PathResolver resolver) {
            PathEntry relativeEntry;
            Map map = PathManagerService.this.pathEntries;
            synchronized (map) {
                relativeEntry = (PathEntry)PathManagerService.this.pathEntries.get(relativeTo);
                if (relativeEntry == null) {
                    throw new IllegalStateException("Could not find relativeTo path '" + relativeTo + "' for relative path '" + name);
                }
            }
            return RelativePathService.doResolve(relativeEntry.resolvePath(), path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isResolved(String relativeTo) {
            Map map = PathManagerService.this.pathEntries;
            synchronized (map) {
                return PathManagerService.this.pathEntries.containsKey(relativeTo);
            }
        }
    };

    protected PathManagerService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPathManagerResources(Resource resource) {
        Map<String, PathEntry> map = this.pathEntries;
        synchronized (map) {
            for (PathEntry pathEntry : this.pathEntries.values()) {
                resource.registerChild(PathElement.pathElement("path", pathEntry.getName()), new HardcodedPathResource("path", pathEntry));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String resolveRelativePathEntry(String path, String relativeTo) {
        if (relativeTo == null) {
            return AbsolutePathService.convertPath(path);
        }
        Map<String, PathEntry> map = this.pathEntries;
        synchronized (map) {
            PathEntry pathEntry = this.pathEntries.get(relativeTo);
            if (pathEntry == null) {
                throw ControllerLogger.ROOT_LOGGER.pathEntryNotFound(relativeTo);
            }
            return RelativePathService.doResolve(pathEntry.resolvePath(), path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final PathManager.Callback.Handle registerCallback(String name, PathManager.Callback callback, PathManager.Event ... events) {
        Map<String, Map<PathManager.Event, Set<PathManager.Callback>>> map = this.callbacks;
        synchronized (map) {
            Map<PathManager.Event, Set<PathManager.Callback>> callbacksByEvent = this.callbacks.get(name);
            if (callbacksByEvent == null) {
                callbacksByEvent = new HashMap<PathManager.Event, Set<PathManager.Callback>>();
                this.callbacks.put(name, callbacksByEvent);
            }
            for (PathManager.Event event : events) {
                Set<PathManager.Callback> callbackSet = callbacksByEvent.get((Object)event);
                if (callbackSet == null) {
                    callbackSet = new HashSet<PathManager.Callback>();
                    callbacksByEvent.put(event, callbackSet);
                }
                callbackSet.add(callback);
            }
        }
        return new HandleImpl(name, callback, events);
    }

    @Override
    public final void start(StartContext context) throws StartException {
    }

    @Override
    public final void stop(StopContext context) {
    }

    @Override
    public final PathManagerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    protected final ServiceController<?> addHardcodedAbsolutePath(ServiceTarget serviceTarget, String pathName, String path) {
        ServiceController<?> controller = this.addAbsolutePathService(serviceTarget, pathName, path);
        this.addPathEntry(pathName, path, null, true);
        return controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final PathEntry getPathEntry(String pathName) {
        Map<String, PathEntry> map = this.pathEntries;
        synchronized (map) {
            PathEntry pathEntry = this.pathEntries.get(pathName);
            if (pathEntry == null) {
                throw ControllerLogger.ROOT_LOGGER.pathEntryNotFound(pathName);
            }
            return pathEntry;
        }
    }

    final void changePathServices(OperationContext operationContext, String pathName, String path) {
        PathEntry pathEntry = this.findPathEntry(pathName);
        this.removePathService(operationContext, pathName);
        if (pathEntry.getRelativeTo() == null) {
            this.addAbsolutePathService(operationContext.getServiceTarget(), pathEntry.getName(), path);
        } else {
            this.addRelativePathService(operationContext.getServiceTarget(), pathEntry.getName(), path, false, pathEntry.getRelativeTo());
        }
    }

    final void changeRelativePathServices(OperationContext operationContext, String pathName, String relativeTo) {
        PathEntry pathEntry = this.findPathEntry(pathName);
        this.removePathService(operationContext, pathEntry.getName());
        if (relativeTo == null) {
            this.addAbsolutePathService(operationContext.getServiceTarget(), pathEntry.getName(), pathEntry.getPath());
        } else {
            this.addRelativePathService(operationContext.getServiceTarget(), pathEntry.getName(), pathEntry.getPath(), false, relativeTo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<PathEntry> getPaths() {
        Map<String, PathEntry> map = this.pathEntries;
        synchronized (map) {
            return new ArrayList<PathEntry>(this.pathEntries.values());
        }
    }

    final void removePathService(OperationContext operationContext, String pathName) {
        ServiceController<?> serviceController = operationContext.getServiceRegistry(true).getService(AbstractPathService.pathNameOf(pathName));
        if (serviceController != null) {
            operationContext.removeService(serviceController);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removePathEntry(String pathName, boolean check) throws OperationFailedException {
        Map<String, PathEntry> map = this.pathEntries;
        synchronized (map) {
            PathEntry pathEntry = this.pathEntries.get(pathName);
            if (pathEntry.isReadOnly()) {
                throw ControllerLogger.ROOT_LOGGER.pathEntryIsReadOnly(pathName);
            }
            Set<String> dependents = this.dependenctRelativePaths.get(pathName);
            if (check && dependents != null) {
                throw ControllerLogger.ROOT_LOGGER.cannotRemovePathWithDependencies(pathName, dependents);
            }
            this.pathEntries.remove(pathName);
            this.triggerCallbacksForEvent(pathEntry, PathManager.Event.REMOVED);
            if (pathEntry.getRelativeTo() != null && (dependents = this.dependenctRelativePaths.get(pathEntry.getRelativeTo())) != null) {
                dependents.remove(pathEntry.getName());
                if (dependents.size() == 0) {
                    this.dependenctRelativePaths.remove(pathEntry.getRelativeTo());
                }
            }
        }
    }

    final ServiceController<?> addAbsolutePathService(ServiceTarget serviceTarget, String pathName, String path) {
        return AbsolutePathService.addService(pathName, path, serviceTarget, null, new ServiceListener[0]);
    }

    final ServiceController<?> addRelativePathService(ServiceTarget serviceTarget, String pathName, String path, boolean possiblyAbsolute, String relativeTo) {
        if (possiblyAbsolute && AbstractPathService.isAbsoluteUnixOrWindowsPath(path)) {
            return this.addAbsolutePathService(serviceTarget, pathName, path);
        }
        return RelativePathService.addService(AbstractPathService.pathNameOf(pathName), path, possiblyAbsolute, relativeTo, serviceTarget, null, new ServiceListener[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PathEntry addPathEntry(String pathName, String path, String relativeTo, boolean readOnly) {
        PathEntry pathEntry;
        Map<String, PathEntry> map = this.pathEntries;
        synchronized (map) {
            if (this.pathEntries.containsKey(pathName)) {
                throw ControllerLogger.ROOT_LOGGER.pathEntryAlreadyExists(pathName);
            }
            pathEntry = new PathEntry(pathName, path, relativeTo, readOnly, relativeTo == null ? this.absoluteResolver : this.relativeResolver);
            this.pathEntries.put(pathName, pathEntry);
            if (relativeTo != null) {
                this.addDependent(pathName, relativeTo);
            }
        }
        this.triggerCallbacksForEvent(pathEntry, PathManager.Event.ADDED);
        return pathEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void changeRelativePath(String pathName, String relativePath, boolean check) throws OperationFailedException {
        PathEntry pathEntry = this.findPathEntry(pathName);
        Map<String, PathEntry> map = this.pathEntries;
        synchronized (map) {
            if (pathEntry.getRelativeTo() != null) {
                Set<String> dependents = this.dependenctRelativePaths.get(pathEntry.getRelativeTo());
                dependents.remove(pathEntry.getName());
            }
            if (check && relativePath != null && this.pathEntries.get(relativePath) == null) {
                throw ControllerLogger.ROOT_LOGGER.pathEntryNotFound(pathName);
            }
            pathEntry.setRelativeTo(relativePath);
            pathEntry.setPathResolver(relativePath == null ? this.absoluteResolver : this.relativeResolver);
            this.addDependent(pathEntry.getName(), pathEntry.getRelativeTo());
        }
        this.triggerCallbacksForEvent(pathEntry, PathManager.Event.UPDATED);
    }

    final void changePath(String pathName, String path) {
        PathEntry pathEntry = this.findPathEntry(pathName);
        pathEntry.setPath(path);
        this.triggerCallbacksForEvent(pathEntry, PathManager.Event.UPDATED);
    }

    private void addDependent(String pathName, String relativeTo) {
        if (relativeTo != null) {
            Set<String> dependents = this.dependenctRelativePaths.get(relativeTo);
            if (dependents == null) {
                dependents = new HashSet<String>();
                this.dependenctRelativePaths.put(relativeTo, dependents);
            }
            dependents.add(pathName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathEntry findPathEntry(String pathName) {
        PathEntry pathEntry;
        Map<String, PathEntry> map = this.pathEntries;
        synchronized (map) {
            pathEntry = this.pathEntries.get(pathName);
            if (pathEntry == null) {
                throw ControllerLogger.ROOT_LOGGER.pathEntryNotFound(pathName);
            }
        }
        return pathEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerCallbacksForEvent(PathEntry pathEntry, PathManager.Event event) {
        Set<PathEntry> allEntries = null;
        Map<String, PathEntry> map = this.pathEntries;
        synchronized (map) {
            if (event == PathManager.Event.UPDATED) {
                allEntries = new LinkedHashSet<PathEntry>();
                allEntries.add(pathEntry);
                this.getAllDependents(allEntries, pathEntry.getName());
            } else {
                allEntries = Collections.singleton(pathEntry);
            }
        }
        LinkedHashMap<PathEntry, LinkedHashSet<PathManager.Callback>> triggerCallbacks = new LinkedHashMap<PathEntry, LinkedHashSet<PathManager.Callback>>();
        Map<String, Map<PathManager.Event, Set<PathManager.Callback>>> map2 = this.callbacks;
        synchronized (map2) {
            for (PathEntry pe : allEntries) {
                Set<PathManager.Callback> callbacksForEntry;
                Map<PathManager.Event, Set<PathManager.Callback>> callbacksByEvent = this.callbacks.get(pe.getName());
                if (callbacksByEvent == null || (callbacksForEntry = callbacksByEvent.get((Object)event)) == null) continue;
                triggerCallbacks.put(pe, new LinkedHashSet<PathManager.Callback>(callbacksForEntry));
            }
        }
        for (Map.Entry entry : triggerCallbacks.entrySet()) {
            for (PathManager.Callback cb : (Set)entry.getValue()) {
                cb.pathEvent(event, (PathEntry)entry.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PathEventContextImpl checkRestartRequired(OperationContext operationContext, String name, PathManager.Event event) {
        Set<String> allEntries = null;
        Map<String, PathEntry> map = this.pathEntries;
        synchronized (map) {
            if (event == PathManager.Event.UPDATED) {
                allEntries = new LinkedHashSet<String>();
                allEntries.add(name);
                this.getAllDependentsForRestartCheck(allEntries, name);
            } else {
                allEntries = Collections.singleton(name);
            }
        }
        LinkedHashMap<String, LinkedHashSet<PathManager.Callback>> triggerCallbacks = new LinkedHashMap<String, LinkedHashSet<PathManager.Callback>>();
        Map<String, Map<PathManager.Event, Set<PathManager.Callback>>> map2 = this.callbacks;
        synchronized (map2) {
            for (String string : allEntries) {
                Set<PathManager.Callback> callbacksForEntry;
                Map<PathManager.Event, Set<PathManager.Callback>> callbacksByEvent = this.callbacks.get(string);
                if (callbacksByEvent == null || (callbacksForEntry = callbacksByEvent.get((Object)event)) == null) continue;
                triggerCallbacks.put(string, new LinkedHashSet<PathManager.Callback>(callbacksForEntry));
            }
        }
        PathEventContextImpl pathEventContext = new PathEventContextImpl(operationContext, event);
        for (Map.Entry entry : triggerCallbacks.entrySet()) {
            for (PathManager.Callback cb : (Set)entry.getValue()) {
                cb.pathModelEvent(pathEventContext, (String)entry.getKey());
                if (!pathEventContext.restart) continue;
                return pathEventContext;
            }
        }
        return pathEventContext;
    }

    private void getAllDependents(Set<PathEntry> result, String name) {
        Set<String> depNames = this.dependenctRelativePaths.get(name);
        if (depNames == null) {
            return;
        }
        for (String dep : depNames) {
            PathEntry entry = this.pathEntries.get(dep);
            if (entry == null) continue;
            result.add(entry);
            this.getAllDependents(result, dep);
        }
    }

    private void getAllDependentsForRestartCheck(Set<String> result, String name) {
        Set<String> depNames = this.dependenctRelativePaths.get(name);
        if (depNames == null) {
            return;
        }
        for (String dep : depNames) {
            PathEntry entry = this.pathEntries.get(dep);
            if (entry == null) continue;
            result.add(dep);
            this.getAllDependentsForRestartCheck(result, dep);
        }
    }

    static class PathEventContextImpl
    implements PathManager.PathEventContext {
        private final OperationContext operationContext;
        private final PathManager.Event event;
        private volatile boolean reload;
        private volatile boolean restart;

        PathEventContextImpl(OperationContext operationContext, PathManager.Event event) {
            this.operationContext = operationContext;
            this.event = event;
        }

        @Override
        public boolean isBooting() {
            return this.operationContext.isBooting();
        }

        @Override
        public boolean isNormalServer() {
            return this.operationContext.isNormalServer();
        }

        @Override
        public boolean isResourceServiceRestartAllowed() {
            return this.operationContext.isResourceServiceRestartAllowed();
        }

        @Override
        public void reloadRequired() {
            this.reload = true;
            this.operationContext.reloadRequired();
        }

        @Override
        public void restartRequired() {
            this.restart = true;
            this.operationContext.restartRequired();
        }

        @Override
        public PathManager.Event getEvent() {
            return this.event;
        }

        void revert() {
            if (this.restart) {
                this.operationContext.revertRestartRequired();
            }
            if (this.reload) {
                this.operationContext.revertReloadRequired();
            }
        }

        boolean isInstallServices() {
            return !this.restart && !this.reload;
        }
    }

    private class HandleImpl
    implements PathManager.Callback.Handle {
        private final String pathName;
        private final PathManager.Callback callback;
        private final PathManager.Event[] events;

        public HandleImpl(String pathName, PathManager.Callback callback, PathManager.Event ... events) {
            this.pathName = pathName;
            this.callback = callback;
            this.events = events;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Map map = PathManagerService.this.callbacks;
            synchronized (map) {
                Map callbacksByEvent = (Map)PathManagerService.this.callbacks.get(this.pathName);
                if (callbacksByEvent != null) {
                    for (PathManager.Event event : this.events) {
                        Set callbackSet = (Set)callbacksByEvent.get((Object)event);
                        if (callbackSet != null) {
                            callbackSet.remove(this.callback);
                        }
                        if (!callbackSet.isEmpty()) continue;
                        callbacksByEvent.remove((Object)event);
                    }
                    if (callbacksByEvent.isEmpty()) {
                        PathManagerService.this.callbacks.remove(this.pathName);
                    }
                }
            }
        }
    }
}

