/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.hawkular.agent.javaagent.config.Configuration;
import org.hawkular.agent.javaagent.config.DMRAvail;
import org.hawkular.agent.javaagent.config.DMRAvailSet;
import org.hawkular.agent.javaagent.config.DMRMetric;
import org.hawkular.agent.javaagent.config.DMRMetricSet;
import org.hawkular.agent.javaagent.config.DMRNotification;
import org.hawkular.agent.javaagent.config.DMROperation;
import org.hawkular.agent.javaagent.config.DMROperationParam;
import org.hawkular.agent.javaagent.config.DMRResourceConfig;
import org.hawkular.agent.javaagent.config.DMRResourceType;
import org.hawkular.agent.javaagent.config.DMRResourceTypeSet;
import org.hawkular.agent.javaagent.config.JMXAvail;
import org.hawkular.agent.javaagent.config.JMXAvailSet;
import org.hawkular.agent.javaagent.config.JMXMetric;
import org.hawkular.agent.javaagent.config.JMXMetricSet;
import org.hawkular.agent.javaagent.config.JMXOperation;
import org.hawkular.agent.javaagent.config.JMXResourceConfig;
import org.hawkular.agent.javaagent.config.JMXResourceType;
import org.hawkular.agent.javaagent.config.JMXResourceTypeSet;
import org.hawkular.agent.javaagent.config.RemoteDMR;
import org.hawkular.agent.javaagent.config.RemoteJMX;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.agent.javaagent.config.WaitFor;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.ConnectionData;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.Interval;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.inventory.NamedObject;
import org.hawkular.agent.monitor.inventory.Operation;
import org.hawkular.agent.monitor.inventory.OperationParam;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyType;
import org.hawkular.agent.monitor.inventory.ResourceType;
import org.hawkular.agent.monitor.inventory.TypeSet;
import org.hawkular.agent.monitor.inventory.TypeSets;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.Constants;
import org.hawkular.agent.monitor.protocol.platform.PlatformNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.PlatformPath;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.helpers.MeasurementUnit;

public class ConfigConverter {
    private final Configuration sourceConfig;

    public ConfigConverter(Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        this.sourceConfig = config;
    }

    public AgentCoreEngineConfiguration convert() throws Exception {
        Configuration config = this.sourceConfig;
        config.validate();
        AgentCoreEngineConfiguration.GlobalConfiguration globalConfiguration = new AgentCoreEngineConfiguration.GlobalConfiguration(config.getSubsystem().getEnabled().booleanValue(), config.getSubsystem().getImmutable().booleanValue(), config.getSubsystem().getInContainer().booleanValue(), null, config.getSubsystem().getAutoDiscoveryScanPeriodSecs().intValue(), config.getSubsystem().getMinCollectionIntervalSecs().intValue(), 2, config.getSubsystem().getMetricDispatcherBufferSize().intValue(), config.getSubsystem().getMetricDispatcherMaxBatchSize().intValue(), config.getSubsystem().getAvailDispatcherBufferSize().intValue(), config.getSubsystem().getAvailDispatcherMaxBatchSize().intValue(), config.getSubsystem().getPingPeriodSecs().intValue());
        AgentCoreEngineConfiguration.DiagnosticsConfiguration diagnostics = new AgentCoreEngineConfiguration.DiagnosticsConfiguration(config.getDiagnostics().getEnabled().booleanValue(), AgentCoreEngineConfiguration.DiagnosticsReportTo.valueOf((String)config.getDiagnostics().getReportTo().name()), config.getDiagnostics().getInterval().intValue(), config.getDiagnostics().getTimeUnits().toJavaTimeUnit());
        AgentCoreEngineConfiguration.StorageAdapterConfiguration storageAdapter = new AgentCoreEngineConfiguration.StorageAdapterConfiguration(AgentCoreEngineConfiguration.StorageReportTo.valueOf((String)config.getStorageAdapter().getType().name()), config.getStorageAdapter().getUsername(), config.getStorageAdapter().getPassword(), config.getStorageAdapter().getTenantId(), config.getStorageAdapter().getFeedId(), config.getStorageAdapter().getUrl(), config.getStorageAdapter().useSSL(), null, config.getStorageAdapter().getMetricsContext(), config.getStorageAdapter().getFeedcommContext(), config.getStorageAdapter().getHawkularContext(), null, null, config.getStorageAdapter().getSecurityRealmName(), config.getStorageAdapter().getConnectTimeoutSecs().intValue(), config.getStorageAdapter().getReadTimeoutSecs().intValue());
        AgentCoreEngineConfiguration.ProtocolConfiguration<DMRNodeLocation> dmrConfiguration = this.buildDmrConfiguration(config);
        AgentCoreEngineConfiguration.ProtocolConfiguration<JMXNodeLocation> jmxConfiguration = this.buildJmxConfiguration(config);
        AgentCoreEngineConfiguration.ProtocolConfiguration<PlatformNodeLocation> platformConfiguration = this.buildPlatformConfiguration(config);
        AgentCoreEngineConfiguration agentConfig = new AgentCoreEngineConfiguration(globalConfiguration, diagnostics, storageAdapter, dmrConfiguration, jmxConfiguration, platformConfiguration);
        return agentConfig;
    }

    /*
     * WARNING - void declaration
     */
    private AgentCoreEngineConfiguration.ProtocolConfiguration<DMRNodeLocation> buildDmrConfiguration(Configuration config) throws Exception {
        MetricType type;
        AttributeLocation aLocation;
        DMRNodeLocation location;
        TypeSet.TypeSetBuilder typeSet;
        TypeSets.Builder typeSets = new TypeSets.Builder();
        for (DMRMetricSet dMRMetricSet : config.getDmrMetricSets()) {
            typeSet = TypeSet.builder();
            typeSet.name(new Name(dMRMetricSet.getName()));
            typeSet.enabled(dMRMetricSet.getEnabled().booleanValue());
            for (DMRMetric dMRMetric : dMRMetricSet.getDmrMetrics()) {
                location = new DMRNodeLocation(this.getDmrPathAddress(dMRMetric.getPath()), dMRMetric.getResolveExpressions().booleanValue(), dMRMetric.getIncludeDefaults().booleanValue());
                aLocation = new AttributeLocation((Object)location, dMRMetric.getAttribute());
                type = new MetricType(new ID(dMRMetricSet.getName() + "~" + dMRMetric.getName()), new Name(dMRMetric.getName()), aLocation, new Interval(dMRMetric.getInterval().intValue(), dMRMetric.getTimeUnits().toJavaTimeUnit()), dMRMetric.getMetricUnits(), dMRMetric.getMetricType(), dMRMetric.getMetricIdTemplate(), dMRMetric.getMetricTags());
                typeSet.type((NamedObject)type);
            }
            typeSets.metricTypeSet(typeSet.build());
        }
        for (Validatable validatable : config.getDmrAvailSets()) {
            typeSet = TypeSet.builder();
            typeSet.name(new Name(((DMRAvailSet)validatable).getName()));
            typeSet.enabled(((DMRAvailSet)validatable).getEnabled().booleanValue());
            for (Validatable validatable2 : ((DMRAvailSet)validatable).getDmrAvails()) {
                location = new DMRNodeLocation(this.getDmrPathAddress(((DMRAvail)validatable2).getPath()), ((DMRAvail)validatable2).getResolveExpressions().booleanValue(), ((DMRAvail)validatable2).getIncludeDefaults().booleanValue());
                aLocation = new AttributeLocation((Object)location, ((DMRAvail)validatable2).getAttribute());
                type = new AvailType(new ID(((DMRAvailSet)validatable).getName() + "~" + ((DMRAvail)validatable2).getName()), new Name(((DMRAvail)validatable2).getName()), aLocation, new Interval(((DMRAvail)validatable2).getInterval().intValue(), ((DMRAvail)validatable2).getTimeUnits().toJavaTimeUnit()), Pattern.compile(((DMRAvail)validatable2).getUpRegex()), ((DMRAvail)validatable2).getMetricIdTemplate(), ((DMRAvail)validatable2).getMetricTags());
                typeSet.type((NamedObject)type);
            }
            typeSets.availTypeSet(typeSet.build());
        }
        for (Validatable validatable : config.getDmrResourceTypeSets()) {
            typeSet = TypeSet.builder();
            typeSet.name(new Name(((DMRResourceTypeSet)validatable).getName()));
            typeSet.enabled(((DMRResourceTypeSet)validatable).getEnabled().booleanValue());
            for (Validatable validatable3 : ((DMRResourceTypeSet)validatable).getDmrResourceTypes()) {
                ResourceType.Builder rtBuilder = ResourceType.builder();
                rtBuilder.name(new Name(((DMRResourceType)validatable3).getName()));
                rtBuilder.location((Object)DMRNodeLocation.of((String)((DMRResourceType)validatable3).getPath()));
                rtBuilder.resourceNameTemplate(((DMRResourceType)validatable3).getResourceNameTemplate());
                if (((DMRResourceType)validatable3).getParents() != null) {
                    for (String parent : ((DMRResourceType)validatable3).getParents()) {
                        rtBuilder.parent(new Name(parent));
                    }
                }
                if (((DMRResourceType)validatable3).getMetricSets() != null) {
                    for (String metricSet : ((DMRResourceType)validatable3).getMetricSets()) {
                        rtBuilder.metricSetName(new Name(metricSet));
                    }
                }
                if (((DMRResourceType)validatable3).getAvailSets() != null) {
                    for (String availSet : ((DMRResourceType)validatable3).getAvailSets()) {
                        rtBuilder.availSetName(new Name(availSet));
                    }
                }
                if (((DMRResourceType)validatable3).getDmrNotifications() != null) {
                    for (DMRNotification notification : ((DMRResourceType)validatable3).getDmrNotifications()) {
                        rtBuilder.notificationType(notification.getNotificationType());
                    }
                }
                if (((DMRResourceType)validatable3).getDmrResourceConfigs() != null) {
                    for (DMRResourceConfig resConfig : ((DMRResourceType)validatable3).getDmrResourceConfigs()) {
                        DMRNodeLocation location2 = new DMRNodeLocation(this.getDmrPathAddress(resConfig.getPath()), resConfig.getResolveExpressions().booleanValue(), resConfig.getIncludeDefaults().booleanValue());
                        AttributeLocation aLocation2 = new AttributeLocation((Object)location2, resConfig.getAttribute());
                        rtBuilder.resourceConfigurationPropertyType(new ResourceConfigurationPropertyType(ID.NULL_ID, new Name(resConfig.getName()), aLocation2));
                    }
                }
                if (((DMRResourceType)validatable3).getDmrOperations() != null) {
                    for (DMROperation dmrOp : ((DMRResourceType)validatable3).getDmrOperations()) {
                        PathAddress path = this.getDmrPathAddress(dmrOp.getPath());
                        ArrayList<OperationParam> params = new ArrayList<OperationParam>();
                        if (dmrOp.getDmrOperationParams() != null) {
                            for (DMROperationParam dmrParam : dmrOp.getDmrOperationParams()) {
                                OperationParam param = new OperationParam(dmrParam.getName(), dmrParam.getType(), dmrParam.getDescription(), dmrParam.getDefaultValue(), dmrParam.getRequired());
                                params.add(param);
                            }
                        }
                        Operation op = new Operation(ID.NULL_ID, new Name(dmrOp.getName()), (Object)new DMRNodeLocation(path), dmrOp.getInternalName(), dmrOp.getModifies().booleanValue(), params);
                        rtBuilder.operation(op);
                    }
                }
                ConfigConverter.populateMetricAndAvailTypesForResourceType(rtBuilder, typeSets);
                typeSet.type((NamedObject)rtBuilder.build());
            }
            typeSets.resourceTypeSet(typeSet.build());
        }
        HashMap<String, AgentCoreEngineConfiguration.EndpointConfiguration> managedServers = new HashMap<String, AgentCoreEngineConfiguration.EndpointConfiguration>();
        if (config.getManagedServers().getLocalDmr() != null) {
            int localPort;
            int n;
            ConnectionData connectionData = null;
            String localHost = System.getProperty("jboss.bind.address.management", "127.0.0.1");
            if (localHost.equals("0.0.0.0")) {
                localHost = "127.0.0.1";
            }
            try {
                String localPortOffsetString = System.getProperty("jboss.socket.binding.port-offset", "0");
                n = Integer.parseInt(localPortOffsetString);
            }
            catch (Exception e) {
                throw new Exception("jboss.socket.binding.port-offset is invalid", e);
            }
            try {
                String localPortString = System.getProperty("jboss.management.http.port", "9990");
                localPort = Integer.parseInt(localPortString);
            }
            catch (Exception e) {
                throw new Exception("jboss.management.http.port is invalid", e);
            }
            connectionData = new ConnectionData("http-remoting", localHost, localPort + n, null, null);
            AgentCoreEngineConfiguration.EndpointConfiguration localDmrEndpointConfig = new AgentCoreEngineConfiguration.EndpointConfiguration(config.getManagedServers().getLocalDmr().getName(), config.getManagedServers().getLocalDmr().getEnabled().booleanValue(), this.getNamesFromStrings(config.getManagedServers().getLocalDmr().getResourceTypeSets()), connectionData, null, config.getManagedServers().getLocalDmr().getSetAvailOnShutdown(), config.getManagedServers().getLocalDmr().getTenantId(), config.getManagedServers().getLocalDmr().getMetricIdTemplate(), config.getManagedServers().getLocalDmr().getMetricTags(), null, this.asWaitForList(config.getManagedServers().getLocalDmr().getWaitFor()));
            managedServers.put(config.getManagedServers().getLocalDmr().getName(), localDmrEndpointConfig);
        }
        if (config.getManagedServers().getRemoteDmrs() != null) {
            void var6_16;
            RemoteDMR[] remoteDMRArray = config.getManagedServers().getRemoteDmrs();
            int n = remoteDMRArray.length;
            boolean bl = false;
            while (var6_16 < n) {
                RemoteDMR remoteDmr = remoteDMRArray[var6_16];
                if (remoteDmr.getProtocol() == null) {
                    remoteDmr.setProtocol(remoteDmr.getUseSsl() != false ? "https-remoting" : "http-remoting");
                }
                ConnectionData connectionData = new ConnectionData(remoteDmr.getProtocol(), remoteDmr.getHost(), remoteDmr.getPort().intValue(), remoteDmr.getUsername(), remoteDmr.getPassword());
                AgentCoreEngineConfiguration.EndpointConfiguration remoteDmrEndpointConfig = new AgentCoreEngineConfiguration.EndpointConfiguration(remoteDmr.getName(), remoteDmr.getEnabled().booleanValue(), this.getNamesFromStrings(remoteDmr.getResourceTypeSets()), connectionData, remoteDmr.getSecurityRealmName(), remoteDmr.getSetAvailOnShutdown(), remoteDmr.getTenantId(), remoteDmr.getMetricIdTemplate(), remoteDmr.getMetricTags(), null, this.asWaitForList(remoteDmr.getWaitFor()));
                managedServers.put(remoteDmr.getName(), remoteDmrEndpointConfig);
                ++var6_16;
            }
        }
        return new AgentCoreEngineConfiguration.ProtocolConfiguration(typeSets.build(), managedServers);
    }

    /*
     * WARNING - void declaration
     */
    private AgentCoreEngineConfiguration.ProtocolConfiguration<JMXNodeLocation> buildJmxConfiguration(Configuration config) throws Exception {
        MetricType type;
        AttributeLocation aLocation;
        JMXNodeLocation location;
        TypeSet.TypeSetBuilder typeSet;
        TypeSets.Builder typeSets = new TypeSets.Builder();
        for (JMXMetricSet jMXMetricSet : config.getJmxMetricSets()) {
            typeSet = TypeSet.builder();
            typeSet.name(new Name(jMXMetricSet.getName()));
            typeSet.enabled(jMXMetricSet.getEnabled().booleanValue());
            for (JMXMetric jMXMetric : jMXMetricSet.getJmxMetrics()) {
                location = new JMXNodeLocation(this.getJmxObjectName(jMXMetric.getObjectName()));
                aLocation = new AttributeLocation((Object)location, jMXMetric.getAttribute());
                type = new MetricType(new ID(jMXMetricSet.getName() + "~" + jMXMetric.getName()), new Name(jMXMetric.getName()), aLocation, new Interval(jMXMetric.getInterval().intValue(), jMXMetric.getTimeUnits().toJavaTimeUnit()), jMXMetric.getMetricUnits(), jMXMetric.getMetricType(), jMXMetric.getMetricIdTemplate(), jMXMetric.getMetricTags());
                typeSet.type((NamedObject)type);
            }
            typeSets.metricTypeSet(typeSet.build());
        }
        for (Validatable validatable : config.getJmxAvailSets()) {
            typeSet = TypeSet.builder();
            typeSet.name(new Name(((JMXAvailSet)validatable).getName()));
            typeSet.enabled(((JMXAvailSet)validatable).getEnabled().booleanValue());
            for (Validatable validatable2 : ((JMXAvailSet)validatable).getJmxAvails()) {
                location = new JMXNodeLocation(this.getJmxObjectName(((JMXAvail)validatable2).getObjectName()));
                aLocation = new AttributeLocation((Object)location, ((JMXAvail)validatable2).getAttribute());
                type = new AvailType(new ID(((JMXAvailSet)validatable).getName() + "~" + ((JMXAvail)validatable2).getName()), new Name(((JMXAvail)validatable2).getName()), aLocation, new Interval(((JMXAvail)validatable2).getInterval().intValue(), ((JMXAvail)validatable2).getTimeUnits().toJavaTimeUnit()), Pattern.compile(((JMXAvail)validatable2).getUpRegex()), ((JMXAvail)validatable2).getMetricIdTemplate(), ((JMXAvail)validatable2).getMetricTags());
                typeSet.type((NamedObject)type);
            }
            typeSets.availTypeSet(typeSet.build());
        }
        for (Validatable validatable : config.getJmxResourceTypeSets()) {
            typeSet = TypeSet.builder();
            typeSet.name(new Name(((JMXResourceTypeSet)validatable).getName()));
            typeSet.enabled(((JMXResourceTypeSet)validatable).getEnabled().booleanValue());
            for (Validatable validatable3 : ((JMXResourceTypeSet)validatable).getJmxResourceTypes()) {
                ResourceType.Builder rtBuilder = ResourceType.builder();
                rtBuilder.name(new Name(((JMXResourceType)validatable3).getName()));
                rtBuilder.location((Object)new JMXNodeLocation(this.getJmxObjectName(((JMXResourceType)validatable3).getObjectName())));
                rtBuilder.resourceNameTemplate(((JMXResourceType)validatable3).getResourceNameTemplate());
                if (((JMXResourceType)validatable3).getParents() != null) {
                    for (String parent : ((JMXResourceType)validatable3).getParents()) {
                        rtBuilder.parent(new Name(parent));
                    }
                }
                if (((JMXResourceType)validatable3).getMetricSets() != null) {
                    for (String metricSet : ((JMXResourceType)validatable3).getMetricSets()) {
                        rtBuilder.metricSetName(new Name(metricSet));
                    }
                }
                if (((JMXResourceType)validatable3).getAvailSets() != null) {
                    for (String availSet : ((JMXResourceType)validatable3).getAvailSets()) {
                        rtBuilder.availSetName(new Name(availSet));
                    }
                }
                if (((JMXResourceType)validatable3).getJmxResourceConfigs() != null) {
                    for (JMXResourceConfig resConfig : ((JMXResourceType)validatable3).getJmxResourceConfigs()) {
                        JMXNodeLocation location2 = new JMXNodeLocation(this.getJmxObjectName(resConfig.getObjectName()));
                        AttributeLocation aLocation2 = new AttributeLocation((Object)location2, resConfig.getAttribute());
                        rtBuilder.resourceConfigurationPropertyType(new ResourceConfigurationPropertyType(ID.NULL_ID, new Name(resConfig.getName()), aLocation2));
                    }
                }
                if (((JMXResourceType)validatable3).getJmxOperations() != null) {
                    for (JMXOperation jmxOp : ((JMXResourceType)validatable3).getJmxOperations()) {
                        ArrayList<OperationParam> params = new ArrayList<OperationParam>();
                        if (jmxOp.getJmxOperationParams() != null) {
                            for (AttributeLocation jmxParam : jmxOp.getJmxOperationParams()) {
                                OperationParam param = new OperationParam(jmxParam.getName(), jmxParam.getType(), jmxParam.getDescription(), jmxParam.getDefaultValue(), jmxParam.getRequired());
                                params.add(param);
                            }
                        }
                        Operation op = new Operation(ID.NULL_ID, new Name(jmxOp.getName()), (Object)new JMXNodeLocation(jmxOp.getObjectName()), jmxOp.getInternalName(), jmxOp.getModifies().booleanValue(), params);
                        rtBuilder.operation(op);
                    }
                }
                ConfigConverter.populateMetricAndAvailTypesForResourceType(rtBuilder, typeSets);
                typeSet.type((NamedObject)rtBuilder.build());
            }
            typeSets.resourceTypeSet(typeSet.build());
        }
        HashMap<String, AgentCoreEngineConfiguration.EndpointConfiguration> managedServers = new HashMap<String, AgentCoreEngineConfiguration.EndpointConfiguration>();
        if (config.getManagedServers().getLocalJmx() != null) {
            AgentCoreEngineConfiguration.EndpointConfiguration localJmx = new AgentCoreEngineConfiguration.EndpointConfiguration(config.getManagedServers().getLocalJmx().getName(), config.getManagedServers().getLocalJmx().getEnabled().booleanValue(), this.getNamesFromStrings(config.getManagedServers().getLocalJmx().getResourceTypeSets()), null, null, config.getManagedServers().getLocalJmx().getSetAvailOnShutdown(), config.getManagedServers().getLocalJmx().getTenantId(), config.getManagedServers().getLocalJmx().getMetricIdTemplate(), config.getManagedServers().getLocalJmx().getMetricTags(), Collections.singletonMap("mbean-server-name", config.getManagedServers().getLocalJmx().getMbeanServerName()), this.asWaitForList(config.getManagedServers().getLocalJmx().getWaitFor()));
            managedServers.put(config.getManagedServers().getLocalJmx().getName(), localJmx);
        }
        if (config.getManagedServers().getRemoteJmxs() != null) {
            void var6_14;
            RemoteJMX[] remoteJMXArray = config.getManagedServers().getRemoteJmxs();
            int n = remoteJMXArray.length;
            boolean bl = false;
            while (var6_14 < n) {
                URI url;
                RemoteJMX remoteJmx = remoteJMXArray[var6_14];
                try {
                    url = new URI(remoteJmx.getUrl());
                }
                catch (Exception e) {
                    throw new Exception("Remote JMX [" + remoteJmx.getName() + "] has invalid URL", e);
                }
                ConnectionData connectionData = new ConnectionData(url, remoteJmx.getUsername(), remoteJmx.getPassword());
                AgentCoreEngineConfiguration.EndpointConfiguration remoteJmxEndpointConfig = new AgentCoreEngineConfiguration.EndpointConfiguration(remoteJmx.getName(), remoteJmx.getEnabled().booleanValue(), this.getNamesFromStrings(remoteJmx.getResourceTypeSets()), connectionData, remoteJmx.getSecurityRealmName(), remoteJmx.getSetAvailOnShutdown(), remoteJmx.getTenantId(), remoteJmx.getMetricIdTemplate(), remoteJmx.getMetricTags(), null, this.asWaitForList(remoteJmx.getWaitFor()));
                managedServers.put(remoteJmx.getName(), remoteJmxEndpointConfig);
                ++var6_14;
            }
        }
        return new AgentCoreEngineConfiguration.ProtocolConfiguration(typeSets.build(), managedServers);
    }

    private AgentCoreEngineConfiguration.ProtocolConfiguration<PlatformNodeLocation> buildPlatformConfiguration(Configuration config) {
        TypeSet typeSet;
        Interval interval;
        if (!config.getPlatform().getEnabled().booleanValue()) {
            HashMap managedServers = new HashMap();
            return new AgentCoreEngineConfiguration.ProtocolConfiguration(TypeSets.empty(), managedServers);
        }
        TypeSets.Builder typeSets = TypeSets.builder();
        ID osId = Constants.PlatformResourceType.OPERATING_SYSTEM.getResourceTypeId();
        Name osName = Constants.PlatformResourceType.OPERATING_SYSTEM.getResourceTypeName();
        ResourceType.Builder rootTypeBldr = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(osId)).name(osName)).location((Object)new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.OPERATING_SYSTEM).build()))).resourceNameTemplate("%s");
        ResourceConfigurationPropertyType machineIdConfigType = new ResourceConfigurationPropertyType(ID.NULL_ID, new Name("Machine Id"), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), "Machine Id"));
        rootTypeBldr.resourceConfigurationPropertyType(machineIdConfigType);
        ResourceConfigurationPropertyType containerIdConfigType = new ResourceConfigurationPropertyType(ID.NULL_ID, new Name("Container Id"), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), "Container Id"));
        rootTypeBldr.resourceConfigurationPropertyType(containerIdConfigType);
        Interval osInterval = new Interval(config.getPlatform().getInterval().intValue(), config.getPlatform().getTimeUnits().toJavaTimeUnit());
        MetricType systemCpuLoad = new MetricType(Constants.PlatformMetricType.OS_SYS_CPU_LOAD.getMetricTypeId(), Constants.PlatformMetricType.OS_SYS_CPU_LOAD.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.OS_SYS_CPU_LOAD.getMetricTypeId().getIDString()), osInterval, MeasurementUnit.PERCENTAGE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
        MetricType systemLoadAverage = new MetricType(Constants.PlatformMetricType.OS_SYS_LOAD_AVG.getMetricTypeId(), Constants.PlatformMetricType.OS_SYS_LOAD_AVG.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.OS_SYS_LOAD_AVG.getMetricTypeId().getIDString()), osInterval, MeasurementUnit.NONE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
        MetricType processCount = new MetricType(Constants.PlatformMetricType.OS_PROCESS_COUNT.getMetricTypeId(), Constants.PlatformMetricType.OS_PROCESS_COUNT.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.OS_PROCESS_COUNT.getMetricTypeId().getIDString()), osInterval, MeasurementUnit.NONE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
        TypeSet osMetrics = TypeSet.builder().name(Constants.PlatformResourceType.OPERATING_SYSTEM.getResourceTypeName()).type((NamedObject)systemCpuLoad).type((NamedObject)systemLoadAverage).type((NamedObject)processCount).build();
        typeSets.metricTypeSet(osMetrics);
        rootTypeBldr.metricSetName(osMetrics.getName());
        ConfigConverter.populateMetricAndAvailTypesForResourceType(rootTypeBldr, typeSets);
        ResourceType rootType = rootTypeBldr.build();
        TypeSet rootTypeSet = TypeSet.builder().enabled(true).name(osName).type((NamedObject)rootType).build();
        typeSets.resourceTypeSet(rootTypeSet);
        if (config.getPlatform().getFileStores() != null && config.getPlatform().getFileStores().getEnabled().booleanValue()) {
            interval = new Interval(config.getPlatform().getFileStores().getInterval().intValue(), config.getPlatform().getFileStores().getTimeUnits().toJavaTimeUnit());
            MetricType usableSpace = new MetricType(Constants.PlatformMetricType.FILE_STORE_USABLE_SPACE.getMetricTypeId(), Constants.PlatformMetricType.FILE_STORE_USABLE_SPACE.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.FILE_STORE_USABLE_SPACE.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
            MetricType totalSpace = new MetricType(Constants.PlatformMetricType.FILE_STORE_TOTAL_SPACE.getMetricTypeId(), Constants.PlatformMetricType.FILE_STORE_TOTAL_SPACE.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.FILE_STORE_TOTAL_SPACE.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
            TypeSet fileStoreMetrics = TypeSet.builder().name(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName()).type((NamedObject)usableSpace).type((NamedObject)totalSpace).build();
            typeSets.metricTypeSet(fileStoreMetrics);
            PlatformNodeLocation fileStoreLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.FILE_STORE).build());
            ResourceType.Builder fileStoreBldr = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.FILE_STORE.getResourceTypeId())).name(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName())).location((Object)fileStoreLocation)).resourceNameTemplate(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName().getNameString() + " [%s]").parent(rootType.getName()).metricSetName(fileStoreMetrics.getName());
            ConfigConverter.populateMetricAndAvailTypesForResourceType(fileStoreBldr, typeSets);
            ResourceType fileStore = fileStoreBldr.build();
            typeSet = TypeSet.builder().name(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName()).type((NamedObject)fileStore).build();
            typeSets.resourceTypeSet(typeSet);
        }
        if (config.getPlatform().getMemory() != null && config.getPlatform().getMemory().getEnabled().booleanValue()) {
            interval = new Interval(config.getPlatform().getMemory().getInterval().intValue(), config.getPlatform().getMemory().getTimeUnits().toJavaTimeUnit());
            MetricType available = new MetricType(Constants.PlatformMetricType.MEMORY_AVAILABLE.getMetricTypeId(), Constants.PlatformMetricType.MEMORY_AVAILABLE.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.MEMORY_AVAILABLE.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
            MetricType total = new MetricType(Constants.PlatformMetricType.MEMORY_TOTAL.getMetricTypeId(), Constants.PlatformMetricType.MEMORY_TOTAL.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.MEMORY_TOTAL.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
            TypeSet memoryMetrics = TypeSet.builder().name(Constants.PlatformResourceType.MEMORY.getResourceTypeName()).type((NamedObject)available).type((NamedObject)total).build();
            typeSets.metricTypeSet(memoryMetrics);
            PlatformNodeLocation memoryLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.MEMORY).build());
            ResourceType.Builder memoryBldr = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.MEMORY.getResourceTypeId())).name(Constants.PlatformResourceType.MEMORY.getResourceTypeName())).parent(rootType.getName()).location((Object)memoryLocation)).metricSetName(memoryMetrics.getName()).resourceNameTemplate(Constants.PlatformResourceType.MEMORY.getResourceTypeName().getNameString());
            ConfigConverter.populateMetricAndAvailTypesForResourceType(memoryBldr, typeSets);
            ResourceType memory = memoryBldr.build();
            typeSet = TypeSet.builder().name(Constants.PlatformResourceType.MEMORY.getResourceTypeName()).type((NamedObject)memory).build();
            typeSets.resourceTypeSet(typeSet);
        }
        if (config.getPlatform().getProcessors() != null && config.getPlatform().getProcessors().getEnabled().booleanValue()) {
            interval = new Interval(config.getPlatform().getProcessors().getInterval().intValue(), config.getPlatform().getProcessors().getTimeUnits().toJavaTimeUnit());
            MetricType cpuUsage = new MetricType(Constants.PlatformMetricType.PROCESSOR_CPU_USAGE.getMetricTypeId(), Constants.PlatformMetricType.PROCESSOR_CPU_USAGE.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.PROCESSOR_CPU_USAGE.getMetricTypeId().getIDString()), interval, MeasurementUnit.PERCENTAGE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
            TypeSet processorMetrics = TypeSet.builder().name(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName()).type((NamedObject)cpuUsage).build();
            typeSets.metricTypeSet(processorMetrics);
            PlatformNodeLocation processorsLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.PROCESSOR).build());
            ResourceType.Builder processorBldr = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.PROCESSOR.getResourceTypeId())).name(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName())).parent(rootType.getName()).location((Object)processorsLocation)).metricSetName(processorMetrics.getName()).resourceNameTemplate(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName().getNameString() + " [%s]");
            ConfigConverter.populateMetricAndAvailTypesForResourceType(processorBldr, typeSets);
            ResourceType processor = processorBldr.build();
            TypeSet typeSet2 = TypeSet.builder().name(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName()).type((NamedObject)processor).build();
            typeSets.resourceTypeSet(typeSet2);
        }
        if (config.getPlatform().getPowerSources() != null && config.getPlatform().getPowerSources().getEnabled().booleanValue()) {
            interval = new Interval(config.getPlatform().getPowerSources().getInterval().intValue(), config.getPlatform().getPowerSources().getTimeUnits().toJavaTimeUnit());
            MetricType remainingCap = new MetricType(Constants.PlatformMetricType.POWER_SOURCE_REMAINING_CAPACITY.getMetricTypeId(), Constants.PlatformMetricType.POWER_SOURCE_REMAINING_CAPACITY.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.POWER_SOURCE_REMAINING_CAPACITY.getMetricTypeId().getIDString()), interval, MeasurementUnit.PERCENTAGE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
            MetricType timeRemaining = new MetricType(Constants.PlatformMetricType.POWER_SOURCE_TIME_REMAINING.getMetricTypeId(), Constants.PlatformMetricType.POWER_SOURCE_TIME_REMAINING.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.POWER_SOURCE_TIME_REMAINING.getMetricTypeId().getIDString()), interval, MeasurementUnit.SECONDS, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
            TypeSet powerSourceMetrics = TypeSet.builder().name(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName()).type((NamedObject)remainingCap).type((NamedObject)timeRemaining).build();
            typeSets.metricTypeSet(powerSourceMetrics);
            PlatformNodeLocation powerSourcesLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.POWER_SOURCE).build());
            ResourceType.Builder powerSourceBldr = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeId())).name(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName())).parent(rootType.getName()).location((Object)powerSourcesLocation)).metricSetName(powerSourceMetrics.getName()).resourceNameTemplate(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName().getNameString() + " [%s]");
            ConfigConverter.populateMetricAndAvailTypesForResourceType(powerSourceBldr, typeSets);
            ResourceType powerSource = powerSourceBldr.build();
            typeSet = TypeSet.builder().name(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName()).type((NamedObject)powerSource).build();
            typeSets.resourceTypeSet(typeSet);
        }
        HashMap<String, AgentCoreEngineConfiguration.EndpointConfiguration> managedServers = new HashMap<String, AgentCoreEngineConfiguration.EndpointConfiguration>();
        if (config.getPlatform().getEnabled().booleanValue()) {
            HashMap<String, String> customData = new HashMap<String, String>(2);
            customData.put("Machine Id", config.getPlatform().getMachineId());
            customData.put("Container Id", config.getPlatform().getContainerId());
            AgentCoreEngineConfiguration.EndpointConfiguration localPlatform = new AgentCoreEngineConfiguration.EndpointConfiguration("platform", true, null, null, null, Avail.DOWN, null, null, null, customData, null);
            managedServers.put("platform", localPlatform);
        }
        return new AgentCoreEngineConfiguration.ProtocolConfiguration(typeSets.build(), managedServers);
    }

    private static <L> void populateMetricAndAvailTypesForResourceType(ResourceType.Builder<?, L> resourceTypeBuilder, TypeSets.Builder<L> typeSetsBuilder) {
        Map metricTypeSets = typeSetsBuilder.getMetricTypeSets();
        List metricSetNames = resourceTypeBuilder.getMetricSetNames();
        for (Name metricSetName : metricSetNames) {
            TypeSet metricSet = (TypeSet)metricTypeSets.get(metricSetName);
            if (metricSet == null || !metricSet.isEnabled()) continue;
            resourceTypeBuilder.metricTypes(metricSet.getTypeMap().values());
        }
        Map availTypeSets = typeSetsBuilder.getAvailTypeSets();
        List availSetNames = resourceTypeBuilder.getAvailSetNames();
        for (Name availSetName : availSetNames) {
            TypeSet availSet = (TypeSet)availTypeSets.get(availSetName);
            if (availSet == null || !availSet.isEnabled()) continue;
            resourceTypeBuilder.availTypes(availSet.getTypeMap().values());
        }
    }

    private PathAddress getDmrPathAddress(String path) {
        if (path == null) {
            return PathAddress.EMPTY_ADDRESS;
        }
        if ("/".equals(path)) {
            return PathAddress.EMPTY_ADDRESS;
        }
        return WildflyCompatibilityUtils.parseCLIStyleAddress((String)path);
    }

    private ObjectName getJmxObjectName(String on) throws Exception {
        if (on == null || on.trim().isEmpty()) {
            return null;
        }
        return new ObjectName(on);
    }

    private Collection<Name> getNamesFromStrings(String[] arr) {
        if (arr == null) {
            return Collections.emptyList();
        }
        ArrayList<Name> names = new ArrayList<Name>();
        for (String s : arr) {
            names.add(new Name(s));
        }
        return names;
    }

    private List<AgentCoreEngineConfiguration.AbstractEndpointConfiguration.WaitFor> asWaitForList(WaitFor[] arr) {
        if (arr == null) {
            return Collections.emptyList();
        }
        ArrayList<AgentCoreEngineConfiguration.AbstractEndpointConfiguration.WaitFor> list = new ArrayList<AgentCoreEngineConfiguration.AbstractEndpointConfiguration.WaitFor>(arr.length);
        for (WaitFor arrEle : arr) {
            AgentCoreEngineConfiguration.AbstractEndpointConfiguration.WaitFor wf = new AgentCoreEngineConfiguration.AbstractEndpointConfiguration.WaitFor(arrEle.getName());
            list.add(wf);
        }
        return list;
    }
}

