/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.ConnectionData;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyInstance;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.ProtocolService;
import org.hawkular.agent.monitor.service.AgentCoreEngine;
import org.hawkular.agent.monitor.service.ServiceStatus;
import org.jboss.dmr.ModelNode;

public class InventoryReport {
    public static String getInventoryReport(AgentCoreEngine agent) throws Exception {
        ServiceStatus status = agent.getStatus();
        if (status == ServiceStatus.RUNNING) {
            ModelNode result = new ModelNode();
            List protocolServices = agent.getProtocolServices().getServices();
            for (ProtocolService protocolService : protocolServices) {
                ModelNode protocolServiceNode = result.get(protocolService.getName());
                for (EndpointService endpointService : protocolService.getEndpointServices().values()) {
                    MonitoredEndpoint endpoint = endpointService.getMonitoredEndpoint();
                    AgentCoreEngineConfiguration.EndpointConfiguration endpointConfig = (AgentCoreEngineConfiguration.EndpointConfiguration)endpoint.getEndpointConfiguration();
                    ConnectionData endpointConnectionData = endpointConfig.getConnectionData();
                    Map endpointCustomData = endpointConfig.getCustomData();
                    String tenantId = endpointConfig.getTenantId();
                    ModelNode endpointNode = protocolServiceNode.get(endpoint.getName());
                    endpointNode.get("Feed ID").set(agent.getFeedId());
                    endpointNode.get("Tenant ID").set(tenantId != null ? tenantId : agent.getTenantId());
                    if (endpointConnectionData != null) {
                        ModelNode connDataNode = endpointNode.get("Connection Data");
                        connDataNode.get("URL").set(String.valueOf(endpointConnectionData.getUri()));
                        connDataNode.get("Username").set(String.valueOf(endpointConnectionData.getUsername()));
                    }
                    if (endpointCustomData != null && !endpointCustomData.isEmpty()) {
                        ModelNode customDataNode = endpointNode.get("Custom Data");
                        for (Map.Entry entry : endpointCustomData.entrySet()) {
                            customDataNode.get((String)entry.getKey()).set(String.valueOf(entry.getValue()));
                        }
                    }
                    InventoryReport.buildEndpointNode(endpointNode.get("Resources"), endpointService);
                }
            }
            return result.toJSONString(false);
        }
        throw new Exception("Agent is not running - status is [" + status + "]");
    }

    private static void buildEndpointNode(ModelNode endpointNode, EndpointService<?, ?> endpointService) {
        ResourceManager resourceManager = endpointService.getResourceManager();
        Set resources = resourceManager.getRootResources();
        for (Object resourceObj : resources) {
            ModelNode rootResourceNode = endpointNode.add();
            InventoryReport.processResource(resourceManager, rootResourceNode, (Resource)resourceObj);
        }
    }

    private static void processResource(ResourceManager<?> manager, ModelNode resourceNode, Resource<?> resource) {
        Set children;
        resourceNode = resourceNode.get(resource.getID().getIDString());
        resourceNode.get("Name").set(resource.getName().getNameString());
        resourceNode.get("Type ID").set(resource.getResourceType().getID().getIDString());
        if (!resource.getResourceConfigurationProperties().isEmpty()) {
            ModelNode resourceConfigNode = resourceNode.get("Resource Configuration");
            for (ResourceConfigurationPropertyInstance config : resource.getResourceConfigurationProperties()) {
                resourceConfigNode.add(config.getName().getNameString(), String.valueOf(config.getValue()));
            }
        }
        if (!(children = manager.getChildren(resource)).isEmpty()) {
            ModelNode childrenNode = resourceNode.get("Children");
            for (Object childObj : children) {
                InventoryReport.processResource(manager, childrenNode, (Resource)childObj);
            }
        }
    }
}

