/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.DMRAvailSet;
import org.hawkular.agent.javaagent.config.DMRMetricSet;
import org.hawkular.agent.javaagent.config.DMRResourceTypeSet;
import org.hawkular.agent.javaagent.config.Diagnostics;
import org.hawkular.agent.javaagent.config.JMXAvailSet;
import org.hawkular.agent.javaagent.config.JMXMetricSet;
import org.hawkular.agent.javaagent.config.JMXResourceTypeSet;
import org.hawkular.agent.javaagent.config.ManagedServers;
import org.hawkular.agent.javaagent.config.Platform;
import org.hawkular.agent.javaagent.config.SecurityRealm;
import org.hawkular.agent.javaagent.config.StorageAdapter;
import org.hawkular.agent.javaagent.config.Subsystem;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class Configuration
implements Validatable {
    @JsonProperty
    private Subsystem subsystem;
    @JsonProperty(value="security-realm")
    private SecurityRealm[] securityRealms;
    @JsonProperty(value="storage-adapter")
    private StorageAdapter storageAdapter = new StorageAdapter();
    @JsonProperty
    private Diagnostics diagnostics = new Diagnostics();
    @JsonProperty(value="metric-set-dmr")
    private DMRMetricSet[] dmrMetricSets;
    @JsonProperty(value="avail-set-dmr")
    private DMRAvailSet[] dmrAvailSets;
    @JsonProperty(value="resource-type-set-dmr")
    private DMRResourceTypeSet[] dmrResourceTypeSets;
    @JsonProperty(value="metric-set-jmx")
    private JMXMetricSet[] jmxMetricSets;
    @JsonProperty(value="avail-set-jmx")
    private JMXAvailSet[] jmxAvailSets;
    @JsonProperty(value="resource-type-set-jmx")
    private JMXResourceTypeSet[] jmxResourceTypeSets;
    @JsonProperty(value="managed-servers")
    private ManagedServers managedServers = new ManagedServers();
    @JsonProperty
    private Platform platform = new Platform();

    public Configuration() {
    }

    public Configuration(Configuration original) {
        this.subsystem = new Subsystem(original.subsystem);
        this.securityRealms = Util.cloneArray(original.securityRealms);
        this.storageAdapter = new StorageAdapter(original.storageAdapter);
        this.diagnostics = new Diagnostics(original.diagnostics);
        this.dmrMetricSets = Util.cloneArray(original.dmrMetricSets);
        this.dmrAvailSets = Util.cloneArray(original.dmrAvailSets);
        this.dmrResourceTypeSets = Util.cloneArray(original.dmrResourceTypeSets);
        this.jmxMetricSets = Util.cloneArray(original.jmxMetricSets);
        this.jmxAvailSets = Util.cloneArray(original.jmxAvailSets);
        this.jmxResourceTypeSets = Util.cloneArray(original.jmxResourceTypeSets);
        this.managedServers = new ManagedServers(original.managedServers);
        this.platform = new Platform(original.platform);
    }

    @Override
    public void validate() throws Exception {
        if (this.subsystem == null) {
            throw new Exception("subsystem must be specified");
        }
        if (this.securityRealms == null) {
            this.securityRealms = new SecurityRealm[0];
        }
        if (this.dmrMetricSets == null) {
            this.dmrMetricSets = new DMRMetricSet[0];
        }
        if (this.dmrAvailSets == null) {
            this.dmrAvailSets = new DMRAvailSet[0];
        }
        if (this.dmrResourceTypeSets == null) {
            this.dmrResourceTypeSets = new DMRResourceTypeSet[0];
        }
        if (this.jmxMetricSets == null) {
            this.jmxMetricSets = new JMXMetricSet[0];
        }
        if (this.jmxAvailSets == null) {
            this.jmxAvailSets = new JMXAvailSet[0];
        }
        if (this.jmxResourceTypeSets == null) {
            this.jmxResourceTypeSets = new JMXResourceTypeSet[0];
        }
        this.subsystem.validate();
        this.storageAdapter.validate();
        for (SecurityRealm securityRealm : this.securityRealms) {
            securityRealm.validate();
        }
        this.diagnostics.validate();
        for (Validatable validatable : this.dmrMetricSets) {
            ((DMRMetricSet)validatable).validate();
        }
        for (Validatable validatable : this.dmrAvailSets) {
            ((DMRAvailSet)validatable).validate();
        }
        for (Validatable validatable : this.dmrResourceTypeSets) {
            ((DMRResourceTypeSet)validatable).validate();
        }
        for (Validatable validatable : this.jmxMetricSets) {
            ((JMXMetricSet)validatable).validate();
        }
        for (Validatable validatable : this.jmxAvailSets) {
            ((JMXAvailSet)validatable).validate();
        }
        for (Validatable validatable : this.jmxResourceTypeSets) {
            ((JMXResourceTypeSet)validatable).validate();
        }
        this.managedServers.validate();
        this.platform.validate();
    }

    public Subsystem getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(Subsystem subsystem) {
        this.subsystem = subsystem;
    }

    public SecurityRealm[] getSecurityRealms() {
        return this.securityRealms;
    }

    public void setSecurityRealms(SecurityRealm[] securityRealms) {
        this.securityRealms = securityRealms;
    }

    public StorageAdapter getStorageAdapter() {
        return this.storageAdapter;
    }

    public void setStorageAdapter(StorageAdapter storageAdapter) {
        this.storageAdapter = storageAdapter;
    }

    public Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    public void setDiagnostics(Diagnostics diagnostics) {
        this.diagnostics = diagnostics;
    }

    public DMRMetricSet[] getDmrMetricSets() {
        return this.dmrMetricSets;
    }

    public void setDmrMetricSets(DMRMetricSet[] dmrMetricSets) {
        this.dmrMetricSets = dmrMetricSets;
    }

    public DMRAvailSet[] getDmrAvailSets() {
        return this.dmrAvailSets;
    }

    public void setDmrAvailSets(DMRAvailSet[] dmrAvailSets) {
        this.dmrAvailSets = dmrAvailSets;
    }

    public DMRResourceTypeSet[] getDmrResourceTypeSets() {
        return this.dmrResourceTypeSets;
    }

    public void setDmrResourceTypeSets(DMRResourceTypeSet[] dmrResourceTypeSets) {
        this.dmrResourceTypeSets = dmrResourceTypeSets;
    }

    public JMXMetricSet[] getJmxMetricSets() {
        return this.jmxMetricSets;
    }

    public void setJmxMetricSets(JMXMetricSet[] jmxMetricSets) {
        this.jmxMetricSets = jmxMetricSets;
    }

    public JMXAvailSet[] getJmxAvailSets() {
        return this.jmxAvailSets;
    }

    public void setJmxAvailSets(JMXAvailSet[] jmxAvailSets) {
        this.jmxAvailSets = jmxAvailSets;
    }

    public JMXResourceTypeSet[] getJmxResourceTypeSets() {
        return this.jmxResourceTypeSets;
    }

    public void setJmxResourceTypeSets(JMXResourceTypeSet[] jmxResourceTypeSets) {
        this.jmxResourceTypeSets = jmxResourceTypeSets;
    }

    public ManagedServers getManagedServers() {
        return this.managedServers;
    }

    public void setManagedServers(ManagedServers managedServers) {
        this.managedServers = managedServers;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }
}

