/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.DMRAvail;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class DMRAvailSet
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty
    private Boolean enabled = Boolean.TRUE;
    @JsonProperty(value="avail-dmr")
    private DMRAvail[] dmrAvails;

    public DMRAvailSet() {
    }

    public DMRAvailSet(DMRAvailSet original) {
        this.name = original.name;
        this.enabled = original.enabled;
        this.dmrAvails = Util.cloneArray(original.dmrAvails);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("avail-set-dmr name must be specified");
        }
        if (this.dmrAvails != null) {
            for (DMRAvail o : this.dmrAvails) {
                o.validate();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public DMRAvail[] getDmrAvails() {
        return this.dmrAvails;
    }

    public void setDmrAvails(DMRAvail[] dmrAvails) {
        this.dmrAvails = dmrAvails;
    }
}

