/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.DMRMetric;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class DMRMetricSet
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty
    private Boolean enabled = Boolean.TRUE;
    @JsonProperty(value="metric-dmr")
    private DMRMetric[] dmrMetrics;

    public DMRMetricSet() {
    }

    public DMRMetricSet(DMRMetricSet original) {
        this.name = original.name;
        this.enabled = original.enabled;
        this.dmrMetrics = Util.cloneArray(original.dmrMetrics);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("metric-set-dmr name must be specified");
        }
        if (this.dmrMetrics != null) {
            for (DMRMetric o : this.dmrMetrics) {
                o.validate();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public DMRMetric[] getDmrMetrics() {
        return this.dmrMetrics;
    }

    public void setDmrMetrics(DMRMetric[] dmrMetrics) {
        this.dmrMetrics = dmrMetrics;
    }
}

