/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import javax.management.ObjectName;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.JMXOperation;
import org.hawkular.agent.javaagent.config.JMXResourceConfig;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class JMXResourceType
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty(value="object-name", required=true)
    private String objectName;
    @JsonProperty(value="resource-name-template", required=true)
    private String resourceNameTemplate;
    @JsonProperty
    private String[] parents;
    @JsonProperty(value="metric-sets")
    private String[] metricSets;
    @JsonProperty(value="avail-sets")
    private String[] availSets;
    @JsonProperty(value="resource-config-jmx")
    private JMXResourceConfig[] jmxResourceConfigs;
    @JsonProperty(value="operation-jmx")
    private JMXOperation[] jmxOperations;

    public JMXResourceType() {
    }

    public JMXResourceType(JMXResourceType original) {
        this.name = original.name;
        this.objectName = original.objectName;
        this.resourceNameTemplate = original.resourceNameTemplate;
        this.parents = original.parents == null ? null : Arrays.copyOf(original.parents, original.parents.length);
        this.metricSets = original.metricSets == null ? null : Arrays.copyOf(original.metricSets, original.metricSets.length);
        this.availSets = original.availSets == null ? null : Arrays.copyOf(original.availSets, original.availSets.length);
        this.jmxResourceConfigs = Util.cloneArray(original.jmxResourceConfigs);
        this.jmxOperations = Util.cloneArray(original.jmxOperations);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("resource-type-jmx name must be specified");
        }
        if (this.objectName == null) {
            throw new Exception("resource-type-jmx [" + this.name + "] object-name must be specified");
        }
        if (this.objectName != null) {
            try {
                new ObjectName(this.objectName);
            }
            catch (Exception e) {
                throw new Exception("resource-type-jmx [" + this.name + "] object-name [" + this.objectName + "] is invalid", e);
            }
        }
        if (this.resourceNameTemplate == null || this.resourceNameTemplate.trim().isEmpty()) {
            throw new Exception("resource-type-jmx [" + this.name + "] resource-name-template must be specified");
        }
        if (this.jmxResourceConfigs != null) {
            for (Validatable validatable : this.jmxResourceConfigs) {
                ((JMXResourceConfig)validatable).validate();
            }
        }
        if (this.jmxOperations != null) {
            for (Validatable validatable : this.jmxOperations) {
                ((JMXOperation)validatable).validate();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getResourceNameTemplate() {
        return this.resourceNameTemplate;
    }

    public void setResourceNameTemplate(String resourceNameTemplate) {
        this.resourceNameTemplate = resourceNameTemplate;
    }

    public String[] getParents() {
        return this.parents;
    }

    public void setParents(String[] parents) {
        this.parents = parents;
    }

    public String[] getMetricSets() {
        return this.metricSets;
    }

    public void setMetricSets(String[] metricSets) {
        this.metricSets = metricSets;
    }

    public String[] getAvailSets() {
        return this.availSets;
    }

    public void setAvailSets(String[] availSets) {
        this.availSets = availSets;
    }

    public JMXResourceConfig[] getJmxResourceConfigs() {
        return this.jmxResourceConfigs;
    }

    public void setJmxResourceConfigs(JMXResourceConfig[] jmxResourceConfigs) {
        this.jmxResourceConfigs = jmxResourceConfigs;
    }

    public JMXOperation[] getJmxOperations() {
        return this.jmxOperations;
    }

    public void setJmxOperations(JMXOperation[] jmxOperations) {
        this.jmxOperations = jmxOperations;
    }
}

