/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.config.BooleanExpression;
import org.hawkular.agent.javaagent.config.StringExpression;
import org.hawkular.agent.javaagent.config.TimeUnits;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class Platform
implements Validatable {
    @JsonProperty
    private BooleanExpression enabled = new BooleanExpression(Boolean.FALSE);
    @JsonProperty
    private Integer interval = 5;
    @JsonProperty(value="time-units")
    private TimeUnits timeUnits = TimeUnits.minutes;
    @JsonProperty(value="machine-id")
    private StringExpression machineId;
    @JsonProperty(value="container-id")
    private StringExpression containerId;
    @JsonProperty(value="file-stores")
    private PlatformChild fileStores = new PlatformChild(true, 5, TimeUnits.minutes);
    @JsonProperty
    private PlatformChild memory = new PlatformChild(true, 5, TimeUnits.minutes);
    @JsonProperty
    private PlatformChild processors = new PlatformChild(true, 5, TimeUnits.minutes);
    @JsonProperty(value="power-sources")
    private PlatformChild powerSources = new PlatformChild(false, 5, TimeUnits.minutes);

    public Platform() {
    }

    public Platform(Platform original) {
        this.enabled = original.enabled == null ? null : new BooleanExpression(original.enabled);
        this.interval = original.interval;
        this.timeUnits = original.timeUnits;
        this.machineId = original.machineId == null ? null : new StringExpression(original.machineId);
        this.containerId = original.containerId == null ? null : new StringExpression(original.containerId);
        this.fileStores = new PlatformChild(original.fileStores);
        this.memory = new PlatformChild(original.memory);
        this.processors = new PlatformChild(original.processors);
        this.powerSources = new PlatformChild(original.powerSources);
    }

    @Override
    public void validate() throws Exception {
        if (this.interval == null || this.interval < 0) {
            throw new Exception("platform intervals must be greater than or equal to 0");
        }
    }

    public Boolean getEnabled() {
        return this.enabled == null ? null : (Boolean)this.enabled.get();
    }

    public void setEnabled(Boolean enabled) {
        if (this.enabled != null) {
            this.enabled.set(enabled);
        } else {
            this.enabled = new BooleanExpression(enabled);
        }
    }

    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public TimeUnits getTimeUnits() {
        return this.timeUnits;
    }

    public void setTimeUnits(TimeUnits timeUnits) {
        this.timeUnits = timeUnits;
    }

    public String getMachineId() {
        return this.machineId == null ? null : ((StringExpression.StringValue)this.machineId.get()).toString();
    }

    public void setMachineId(String machineId) {
        if (this.machineId != null) {
            this.machineId.set(new StringExpression.StringValue(machineId));
        } else {
            this.machineId = new StringExpression(new StringExpression.StringValue(machineId));
        }
    }

    public String getContainerId() {
        return this.containerId == null ? null : ((StringExpression.StringValue)this.containerId.get()).toString();
    }

    public void setContainerId(String containerId) {
        if (this.containerId != null) {
            this.containerId.set(new StringExpression.StringValue(containerId));
        } else {
            this.containerId = new StringExpression(new StringExpression.StringValue(containerId));
        }
    }

    public PlatformChild getFileStores() {
        return this.fileStores;
    }

    public void setFileStores(PlatformChild fileStores) {
        this.fileStores = fileStores;
    }

    public PlatformChild getMemory() {
        return this.memory;
    }

    public void setMemory(PlatformChild memory) {
        this.memory = memory;
    }

    public PlatformChild getProcessors() {
        return this.processors;
    }

    public void setProcessors(PlatformChild processors) {
        this.processors = processors;
    }

    public PlatformChild getPowerSources() {
        return this.powerSources;
    }

    public void setPowerSources(PlatformChild powerSources) {
        this.powerSources = powerSources;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class PlatformChild
    implements Validatable {
        @JsonProperty
        private BooleanExpression enabled = new BooleanExpression(Boolean.TRUE);
        @JsonProperty
        private Integer interval = 5;
        @JsonProperty(value="time-units")
        private TimeUnits timeUnits = TimeUnits.minutes;

        public PlatformChild() {
        }

        public PlatformChild(PlatformChild original) {
            this.enabled = original.enabled == null ? null : new BooleanExpression(original.enabled);
            this.interval = original.interval;
            this.timeUnits = original.timeUnits;
        }

        public PlatformChild(Boolean e, Integer i, TimeUnits t) {
            this.enabled = new BooleanExpression(e);
            this.interval = i;
            this.timeUnits = t;
        }

        @Override
        public void validate() throws Exception {
            if (this.interval == null || this.interval < 0) {
                throw new Exception("platform intervals must be greater than or equal to 0");
            }
        }

        public Boolean getEnabled() {
            return this.enabled == null ? null : (Boolean)this.enabled.get();
        }

        public void setEnabled(Boolean enabled) {
            if (this.enabled != null) {
                this.enabled.set(enabled);
            } else {
                this.enabled = new BooleanExpression(enabled);
            }
        }

        public Integer getInterval() {
            return this.interval;
        }

        public void setInterval(Integer interval) {
            this.interval = interval;
        }

        public TimeUnits getTimeUnits() {
            return this.timeUnits;
        }

        public void setTimeUnits(TimeUnits timeUnits) {
            this.timeUnits = timeUnits;
        }
    }
}

