/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.IOException;
import java.util.Random;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Sink;
import okio.Timeout;

public final class WebSocketWriter {
    private final boolean isClient;
    private final Random random;
    private final BufferedSink sink;
    private boolean writerClosed;
    private final Buffer buffer = new Buffer();
    private final FrameSink frameSink = new FrameSink();
    private boolean activeWriter;
    private final byte[] maskKey;
    private final byte[] maskBuffer;

    public WebSocketWriter(boolean isClient, BufferedSink sink, Random random) {
        if (sink == null) {
            throw new NullPointerException("sink == null");
        }
        if (random == null) {
            throw new NullPointerException("random == null");
        }
        this.isClient = isClient;
        this.sink = sink;
        this.random = random;
        this.maskKey = isClient ? new byte[4] : null;
        this.maskBuffer = isClient ? new byte[8192] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePing(Buffer payload) throws IOException {
        WebSocketWriter webSocketWriter = this;
        synchronized (webSocketWriter) {
            this.writeControlFrameSynchronized(9, payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePong(Buffer payload) throws IOException {
        WebSocketWriter webSocketWriter = this;
        synchronized (webSocketWriter) {
            this.writeControlFrameSynchronized(10, payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeClose(int code, String reason) throws IOException {
        Buffer payload = null;
        if (code != 0 || reason != null) {
            if (code != 0) {
                WebSocketProtocol.validateCloseCode(code, true);
            }
            payload = new Buffer();
            payload.writeShort(code);
            if (reason != null) {
                payload.writeUtf8(reason);
            }
        }
        WebSocketWriter webSocketWriter = this;
        synchronized (webSocketWriter) {
            this.writeControlFrameSynchronized(8, payload);
            this.writerClosed = true;
        }
    }

    private void writeControlFrameSynchronized(int opcode, Buffer payload) throws IOException {
        assert (Thread.holdsLock(this));
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int length = 0;
        if (payload != null && (long)(length = (int)payload.size()) > 125L) {
            throw new IllegalArgumentException("Payload size must be less than or equal to 125");
        }
        int b0 = 0x80 | opcode;
        this.sink.writeByte(b0);
        int b1 = length;
        if (this.isClient) {
            this.sink.writeByte(b1 |= 0x80);
            this.random.nextBytes(this.maskKey);
            this.sink.write(this.maskKey);
            if (payload != null) {
                this.writeMaskedSynchronized(payload, length);
            }
        } else {
            this.sink.writeByte(b1);
            if (payload != null) {
                this.sink.writeAll(payload);
            }
        }
        this.sink.emit();
    }

    public Sink newMessageSink(int formatOpcode, long contentLength) {
        if (this.activeWriter) {
            throw new IllegalStateException("Another message writer is active. Did you call close()?");
        }
        this.activeWriter = true;
        this.frameSink.formatOpcode = formatOpcode;
        this.frameSink.contentLength = contentLength;
        this.frameSink.isFirstFrame = true;
        this.frameSink.closed = false;
        return this.frameSink;
    }

    private void writeMessageFrameSynchronized(int formatOpcode, long byteCount, boolean isFirstFrame, boolean isFinal) throws IOException {
        int b0;
        assert (Thread.holdsLock(this));
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int n = b0 = isFirstFrame ? formatOpcode : 0;
        if (isFinal) {
            b0 |= 0x80;
        }
        this.sink.writeByte(b0);
        int b1 = 0;
        if (this.isClient) {
            b1 |= 0x80;
            this.random.nextBytes(this.maskKey);
        }
        if (byteCount <= 125L) {
            this.sink.writeByte(b1 |= (int)byteCount);
        } else if (byteCount <= 65535L) {
            this.sink.writeByte(b1 |= 0x7E);
            this.sink.writeShort((int)byteCount);
        } else {
            this.sink.writeByte(b1 |= 0x7F);
            this.sink.writeLong(byteCount);
        }
        if (this.isClient) {
            this.sink.write(this.maskKey);
            this.writeMaskedSynchronized(this.buffer, byteCount);
        } else {
            this.sink.write(this.buffer, byteCount);
        }
        this.sink.emit();
    }

    private void writeMaskedSynchronized(BufferedSource source, long byteCount) throws IOException {
        int read;
        assert (Thread.holdsLock(this));
        for (long written = 0L; written < byteCount; written += (long)read) {
            int toRead = (int)Math.min(byteCount, (long)this.maskBuffer.length);
            read = source.read(this.maskBuffer, 0, toRead);
            if (read == -1) {
                throw new AssertionError();
            }
            WebSocketProtocol.toggleMask(this.maskBuffer, read, this.maskKey, written);
            this.sink.write(this.maskBuffer, 0, read);
        }
    }

    private final class FrameSink
    implements Sink {
        private int formatOpcode;
        private long contentLength;
        private boolean isFirstFrame;
        private boolean closed;

        private FrameSink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(Buffer source, long byteCount) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            WebSocketWriter.this.buffer.write(source, byteCount);
            boolean deferWrite = this.isFirstFrame && this.contentLength != -1L && WebSocketWriter.this.buffer.size() > this.contentLength - 8192L;
            long emitCount = WebSocketWriter.this.buffer.completeSegmentByteCount();
            if (emitCount > 0L && !deferWrite) {
                WebSocketWriter webSocketWriter = WebSocketWriter.this;
                synchronized (webSocketWriter) {
                    WebSocketWriter.this.writeMessageFrameSynchronized(this.formatOpcode, emitCount, this.isFirstFrame, false);
                }
                this.isFirstFrame = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            WebSocketWriter webSocketWriter = WebSocketWriter.this;
            synchronized (webSocketWriter) {
                WebSocketWriter.this.writeMessageFrameSynchronized(this.formatOpcode, WebSocketWriter.this.buffer.size(), this.isFirstFrame, false);
            }
            this.isFirstFrame = false;
        }

        @Override
        public Timeout timeout() {
            return WebSocketWriter.this.sink.timeout();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            WebSocketWriter webSocketWriter = WebSocketWriter.this;
            synchronized (webSocketWriter) {
                WebSocketWriter.this.writeMessageFrameSynchronized(this.formatOpcode, WebSocketWriter.this.buffer.size(), this.isFirstFrame, true);
            }
            this.closed = true;
            WebSocketWriter.this.activeWriter = false;
        }
    }
}

