/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.example;

import java.io.IOException;
import java.io.PrintWriter;
import javax.ejb.EJB;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hawkular.agent.example.HawkularWildFlyAgentProvider;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.metrics.client.common.MetricType;

public class MyAppServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @EJB
    private HawkularWildFlyAgentProvider hawkularAgent;

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String newResourceId = request.getParameter("newResourceID");
        String oldResourceId = request.getParameter("oldResourceID");
        String metricKey = request.getParameter("metricKey");
        String availKey = request.getParameter("availKey");
        if (newResourceId == null && oldResourceId == null && metricKey == null && availKey == null) {
            throw new ServletException("Don't know what to do!");
        }
        if (newResourceId != null) {
            this.createNewResource(request, response, newResourceId);
        } else if (oldResourceId != null) {
            this.removeOldResource(request, response, oldResourceId);
        } else if (metricKey != null) {
            Double metricValue = Double.valueOf(request.getParameter("metricValue"));
            this.sendMetric(request, response, metricKey, metricValue);
        } else if (availKey != null) {
            Avail availValue = Avail.valueOf((String)request.getParameter("availValue"));
            this.sendAvail(request, response, availKey, availValue);
        }
    }

    private void sendAvail(HttpServletRequest request, HttpServletResponse response, String availKey, Avail availValue) {
        try {
            this.hawkularAgent.sendAvail(availKey, availValue);
            String results = String.format("<h1>Send Avail</h1>\n<p>Avail Key=%s</p>\n<p>Avail Value=%s</p>", availKey, availValue);
            this.printResults(response, results);
        }
        catch (Exception e) {
            this.printResults(response, "sendAvail failure: " + e);
        }
    }

    private void sendMetric(HttpServletRequest request, HttpServletResponse response, String metricKey, Double metricValue) {
        try {
            this.hawkularAgent.sendMetric(metricKey, metricValue, MetricType.GAUGE);
            String results = String.format("<h1>Send Metric</h1>\n<p>Metric Key=%s</p>\n<p>Metric Value=%s</p>", metricKey, metricValue);
            this.printResults(response, results);
        }
        catch (Exception e) {
            this.printResults(response, "sendMetric failure: " + e);
        }
    }

    private void createNewResource(HttpServletRequest request, HttpServletResponse response, String resourceId) {
        try {
            this.hawkularAgent.addResourceToInventory(resourceId);
            String results = String.format("<h1>Create New Resource</h1>\n<p>Resource=%s</p>", resourceId);
            this.printResults(response, results);
        }
        catch (Exception e) {
            this.printResults(response, "createNewResource failure: " + e);
        }
    }

    private void removeOldResource(HttpServletRequest request, HttpServletResponse response, String resourceId) {
        try {
            this.hawkularAgent.removeResourceFromInventory(resourceId);
            String results = String.format("<h1>Removed Old Resource</h1>\n<p>Resource=%s</p>", resourceId);
            this.printResults(response, results);
        }
        catch (Exception e) {
            this.printResults(response, "removeOldResource failure: " + e);
        }
    }

    private void printResults(HttpServletResponse response, String msg) {
        try {
            PrintWriter out = response.getWriter();
            out.println(msg);
        }
        catch (IOException e) {
            this.log("Cannot print results: " + msg, (Throwable)e);
        }
    }
}

