/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.agent.itest.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.hawkular.agent.monitor.protocol.dmr.DMREndpointService;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.cmdgw.api.ApiDeserializer;
import org.hawkular.cmdgw.api.WelcomeResponse;
import org.hawkular.dmr.api.OperationBuilder;
import org.hawkular.dmrclient.Address;
import org.hawkular.dmrclient.JBossASClient;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.json.InventoryJacksonConfig;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.wildfly.agent.itest.util.WildFlyClientConfig;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractITest {
    private static volatile boolean accountsAndInventoryReady = false;
    protected static final int ATTEMPT_COUNT = 50;
    protected static final long ATTEMPT_DELAY = 5000L;
    protected static final String authentication;
    protected static final String baseMetricsUri;
    protected static final String baseGwUri;
    protected static final String baseInvUri;
    protected static final String hawkularHost;
    protected static final int hawkularHttpPort;
    private static final Logger log;
    protected static final String managementPasword;
    protected static final int hawkularManagementPort;
    protected static final String managementUser;
    protected static final String testPasword;
    protected static final String testUser;
    protected static final String tenantId;
    protected static final String authHeader;
    protected static final String hawkularFeedId;
    protected static final File wfHome;
    protected static final Object waitForAccountsLock;
    protected OkHttpClient client;
    protected ObjectMapper mapper;

    protected static String assertWelcomeResponse(String msg) {
        String welcomeRe = "\\QWelcomeResponse={\"sessionId\":\"\\E.*";
        AssertJUnit.assertTrue((String)("[" + msg + "] does not match [" + welcomeRe + "]"), (boolean)msg.matches(welcomeRe));
        BasicMessageWithExtraData bigMessage = new ApiDeserializer().deserialize(msg);
        return ((WelcomeResponse)bigMessage.getBasicMessage()).getSessionId();
    }

    public static String readNode(Class<?> caller, String nodeFileName) throws IOException {
        URL url = caller.getResource(caller.getSimpleName() + "." + nodeFileName);
        if (url != null) {
            StringBuilder result = new StringBuilder();
            try (InputStreamReader r = new InputStreamReader(url.openStream(), "utf-8");){
                char[] buff = new char[1024];
                int len = 0;
                while ((len = ((Reader)r).read(buff, 0, buff.length)) != -1) {
                    result.append(buff, 0, len);
                }
            }
            return result.toString();
        }
        return null;
    }

    public static void writeNode(Class<?> caller, ModelNode node, String nodeFileName) throws UnsupportedEncodingException, FileNotFoundException {
        URL callerUrl = caller.getResource(caller.getSimpleName() + ".class");
        if (!callerUrl.getProtocol().equals("file")) {
            throw new IllegalStateException(AbstractITest.class.getName() + ".store() works only if the caller's class file is loaded using a file:// URL.");
        }
        String callerUrlPath = callerUrl.getPath();
        String nodePath = callerUrlPath.replaceAll("\\.class$", "." + nodeFileName);
        nodePath = nodePath.replace("/target/test-classes/", "/src/test/resources/");
        System.out.println("Storing a node to [" + nodePath + "]");
        File outputFile = new File(nodePath);
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "utf-8"));){
            node.writeString(out, false);
        }
    }

    @BeforeMethod
    public void before() {
        JsonFactory f = new JsonFactory();
        this.mapper = new ObjectMapper(f);
        InventoryJacksonConfig.configure((ObjectMapper)this.mapper);
        this.client = new OkHttpClient();
    }

    @AfterMethod
    public void after() {
        this.client.getDispatcher().getExecutorService().shutdown();
    }

    protected String getNodeAttribute(ModelControllerClient mcc, ModelNode addressActual, String attributeName) {
        String actualAttributeValue = ((OperationBuilder.ReadAttributeOperationBuilder)OperationBuilder.readAttribute().address(addressActual)).name(attributeName).includeDefaults().execute(mcc).assertSuccess().getResultNode().asString();
        return actualAttributeValue;
    }

    protected void assertNodeAttributeEquals(ModelControllerClient mcc, ModelNode addressActual, String attributeName, String expectedAttributeValue) {
        String actualAttributeValue = this.getNodeAttribute(mcc, addressActual, attributeName);
        Assert.assertEquals((String)actualAttributeValue, (String)expectedAttributeValue);
    }

    protected void assertNodeEquals(ModelControllerClient mcc, ModelNode addressActual, Class<?> caller, String expectedNodeFileName) {
        this.assertNodeEquals(mcc, addressActual, caller, expectedNodeFileName, false);
    }

    protected void assertNodeEquals(ModelControllerClient mcc, ModelNode addressActual, Class<?> caller, String expectedNodeFileName, boolean saveActual) {
        try {
            ModelNode actual = ((OperationBuilder.ReadResourceOperationBuilder)OperationBuilder.readResource().address(addressActual)).includeRuntime().includeDefaults().recursive().execute(mcc).assertSuccess().getResultNode();
            String expected = AbstractITest.readNode(caller, expectedNodeFileName);
            String actualString = actual.toString();
            if (saveActual) {
                AbstractITest.writeNode(caller, actual, expectedNodeFileName + ".actual.txt");
            }
            Assert.assertEquals((String)actualString, (String)expected);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void assertResourceCount(ModelControllerClient mcc, ModelNode address, String childType, int expectedCount) throws IOException {
        ModelNode request = new ModelNode();
        request.get("address").set(address);
        request.get("operation").set("read-children-resources");
        request.get("child-type").set(childType);
        request.get("include-runtime").set(true);
        ModelNode response = mcc.execute(request);
        if (response.hasDefined("outcome") && response.get("outcome").asString().equals("success")) {
            ModelNode result = response.get("result");
            List nodes = result.asPropertyList();
            AssertJUnit.assertEquals((String)("Number of child nodes of [" + address + "] " + response), (int)expectedCount, (int)nodes.size());
        } else if (expectedCount != 0) {
            AssertJUnit.fail((String)("Path [" + address + "] has no child nodes, expected " + expectedCount + " : " + response));
        }
    }

    protected void assertResourceExists(ModelControllerClient mcc, ModelNode address, boolean expectedExists) throws IOException {
        ModelNode request = new ModelNode();
        request.get("address").set(address);
        request.get("operation").set("read-resource");
        request.get("include-runtime").set(true);
        ModelNode result = mcc.execute(request);
        String message = String.format("Model node [%s] %s unexpectedly", address.toString(), expectedExists ? "does not exist" : "exists");
        AssertJUnit.assertTrue((String)String.format(message, result), (Operations.isSuccessfulOutcome((ModelNode)result) == expectedExists ? 1 : 0) != 0);
    }

    protected Resource getResource(String listPath, Predicate<Resource> predicate) throws Throwable {
        return this.getResource(listPath, predicate, 50, 5000L);
    }

    protected Resource getResource(String listPath, Predicate<Resource> predicate, int attemptCount, long attemptDelay) throws Throwable {
        String url = baseInvUri + listPath;
        Throwable e = null;
        for (int i = 0; i < attemptCount; ++i) {
            try {
                String body = this.getWithRetries(url, attemptCount, attemptDelay);
                TypeFactory tf = this.mapper.getTypeFactory();
                CollectionType listType = tf.constructCollectionType(ArrayList.class, Resource.class);
                JsonNode node = this.mapper.readTree(body);
                List result = (List)this.mapper.readValue(node.traverse(), (JavaType)listType);
                Optional<Resource> found = result.stream().filter(predicate).findFirst();
                if (found.isPresent()) {
                    return found.get();
                }
                System.out.println("Could not find the right resource among " + result.size() + " resources on " + (i + 1) + " of " + attemptCount + " attempts for URL [" + url + "]");
            }
            catch (Throwable t) {
                e = t;
                System.out.println("URL [" + url + "] not ready yet on " + (i + 1) + " of " + attemptCount + " attempts, about to retry after " + attemptDelay + " ms: " + t.getMessage());
            }
            Thread.sleep(attemptDelay);
        }
        if (e != null) {
            throw e;
        }
        throw new AssertionError((Object)("Could not get [" + url + "]"));
    }

    protected List<Resource> getResources(String path, int minCount) throws Throwable {
        return this.getResources(path, minCount, 50, 5000L);
    }

    protected List<Resource> getResources(String path, int minCount, int attemptCount, long attemptDelay) throws Throwable {
        String url = baseInvUri + path;
        Throwable e = null;
        for (int i = 0; i < attemptCount; ++i) {
            try {
                String body = this.getWithRetries(url, attemptCount, attemptDelay);
                TypeFactory tf = this.mapper.getTypeFactory();
                CollectionType listType = tf.constructCollectionType(ArrayList.class, Resource.class);
                JsonNode node = this.mapper.readTree(body);
                List result = (List)this.mapper.readValue(node.traverse(), (JavaType)listType);
                if (result.size() >= minCount) {
                    return result;
                }
                System.out.println("Got only " + result.size() + " resources while expected " + minCount + " on " + (i + 1) + " of " + attemptCount + " attempts for URL [" + url + "]");
            }
            catch (Throwable t) {
                e = t;
                System.out.println("URL [" + url + "] not ready yet on " + (i + 1) + " of " + attemptCount + " attempts, about to retry after " + attemptDelay + " ms");
            }
            Thread.sleep(attemptDelay);
        }
        if (e != null) {
            throw e;
        }
        throw new AssertionError((Object)("Could not get [" + url + "]"));
    }

    protected String getWithRetries(String url) throws Throwable {
        return this.getWithRetries(url, 50, 5000L);
    }

    protected String getWithRetries(String url, int attemptCount, long attemptDelay) throws Throwable {
        Throwable e = null;
        for (int i = 0; i < attemptCount; ++i) {
            try {
                Request request = this.newAuthRequest().url(url).build();
                Response response = this.client.newCall(request).execute();
                System.out.println("Got code " + response.code() + " and message [" + response.message() + "] retries: " + url);
                AssertJUnit.assertEquals((int)200, (int)response.code());
                System.out.println("Got after " + (i + 1) + " retries: " + url);
                return response.body().string();
            }
            catch (Throwable t) {
                e = t;
                System.out.println("URL [" + url + "] not ready yet on " + (i + 1) + " of " + attemptCount + " attempts, about to retry after " + attemptDelay + " ms");
                Thread.sleep(attemptDelay);
                continue;
            }
        }
        if (e != null) {
            throw e;
        }
        throw new AssertionError((Object)("Could not get [" + url + "]"));
    }

    protected void assertResourceNotInInventory(String listPath, Predicate<Resource> predicate, int attemptCount, long attemptDelay) throws Throwable {
        try {
            for (int i = 0; i < attemptCount; ++i) {
                this.getResource(listPath, predicate, 1, 1L);
                Thread.sleep(attemptDelay);
            }
        }
        catch (AssertionError expected) {
            return;
        }
        Assert.fail((String)("resource is still in inventory. listPath=" + listPath));
    }

    protected Request.Builder newAuthRequest() {
        return new Request.Builder().addHeader("Authorization", authHeader).addHeader("Accept", "application/json").addHeader("Hawkular-Tenant", tenantId);
    }

    protected static WildFlyClientConfig getPlainWildFlyClientConfig() {
        return new WildFlyClientConfig();
    }

    protected static ModelControllerClient newHawkularModelControllerClient() {
        return AbstractITest.newModelControllerClient(hawkularHost, hawkularManagementPort);
    }

    protected static ModelControllerClient newPlainWildFlyModelControllerClient(WildFlyClientConfig config) {
        return AbstractITest.newModelControllerClient(config.getHost(), config.getManagementPort());
    }

    protected static ModelControllerClient newModelControllerClient(String host, int managementPort) {
        CallbackHandler callbackHandler = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        log.fine("ModelControllerClient is sending a username [" + managementUser + "]");
                        ncb.setName(managementUser);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        log.fine("ModelControllerClient is sending a password [" + managementPasword + "]");
                        pcb.setPassword(managementPasword.toCharArray());
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)current;
                        log.fine("ModelControllerClient is sending a realm [" + rcb.getDefaultText() + "]");
                        rcb.setText(rcb.getDefaultText());
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
            }
        };
        try {
            InetAddress inetAddr = InetAddress.getByName(host);
            log.fine("Connecting a ModelControllerClient to [" + host + ":" + managementPort + "]");
            return ModelControllerClient.Factory.create((InetAddress)inetAddr, (int)managementPort, (CallbackHandler)callbackHandler);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create management client", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Collection<String> getDMRChildrenNames(WildFlyClientConfig config, String childTypeName, PathAddress parentAddress) {
        try (ModelControllerClient mcc2 = config == null ? AbstractITest.newHawkularModelControllerClient() : AbstractITest.newPlainWildFlyModelControllerClient(config);){
            ModelNode result = ((OperationBuilder.StringListOperationResult)((OperationBuilder.ReadChildrenNamesOperationBuilder)OperationBuilder.readChildrenNames().address(parentAddress)).childType(childTypeName).execute(mcc2)).getResultNode();
            Collection collection = result.asList().stream().map(n -> n.asString()).collect(Collectors.toList());
            return collection;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get: " + parentAddress + "/" + childTypeName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForAccountsAndInventory() throws Throwable {
        Object object = waitForAccountsLock;
        synchronized (object) {
            if (!accountsAndInventoryReady) {
                Thread.sleep(10000L);
                this.getWithRetries(baseInvUri + "/tenant");
                accountsAndInventoryReady = true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ModelNode getAgentInventoryReport(String host, int managementPort) {
        try (ModelControllerClient mcc = AbstractITest.newModelControllerClient(host, managementPort);){
            Address agentAddress = Address.parse((String)"/subsystem=hawkular-wildfly-agent");
            ModelNode op = JBossASClient.createRequest((String)"inventoryReport", (Address)agentAddress);
            ModelNode inventoryReport = new JBossASClient(mcc).execute(op);
            if (JBossASClient.isSuccess((ModelNode)inventoryReport)) {
                ModelNode modelNode = JBossASClient.getResults((ModelNode)inventoryReport);
                return modelNode;
            }
            throw new Exception(JBossASClient.getFailureDescription((ModelNode)inventoryReport));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get inventory report", e);
        }
    }

    protected CanonicalPath getHawkularWildFlyServerResourcePath() throws Throwable {
        List<Resource> servers = this.getResources("/feeds/" + hawkularFeedId + "/resources", 2);
        List wfs = servers.stream().filter(s -> "WildFly Server".equals(s.getType().getId())).collect(Collectors.toList());
        AssertJUnit.assertEquals((int)1, (int)wfs.size());
        return ((Resource)wfs.get(0)).getPath();
    }

    protected CanonicalPath getHostController(WildFlyClientConfig hostControllerClientConfig) throws Throwable {
        List<Resource> servers = this.getResources("/feeds/" + hostControllerClientConfig.getFeedId() + "/resources", 2);
        List hcs = servers.stream().filter(s -> "Host Controller".equals(s.getType().getId())).collect(Collectors.toList());
        AssertJUnit.assertEquals((int)1, (int)hcs.size());
        return ((Resource)hcs.get(0)).getPath();
    }

    protected File getTestApplicationFile() {
        String dir = System.getProperty("hawkular.test.staging.dir");
        File app = new File(dir, "hawkular-wildfly-agent-helloworld-war.war");
        Assert.assertTrue((boolean)app.isFile(), (String)("Missing test application - build is bad: " + app.getAbsolutePath()));
        return app;
    }

    private void reload(String host, int managementPort) {
        try (ModelControllerClient mcc = AbstractITest.newModelControllerClient(host, managementPort);){
            OperationBuilder.reload().execute(mcc).assertSuccess();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long timeoutMillis = 600000L;
        long start = System.currentTimeMillis();
        while (true) {
            try (ModelControllerClient reconnectedMcc = AbstractITest.newModelControllerClient(host, managementPort);){
                String status = ((OperationBuilder.ReadAttributeOperationBuilder)OperationBuilder.readAttribute().address().parentBuilder()).name("server-state").execute(reconnectedMcc).assertSuccess().getResultNode().asString();
                if ("RUNNING".equals(status)) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (start + 600000L < System.currentTimeMillis()) {
                throw new RuntimeException("Server reload timeouted after " + (System.currentTimeMillis() - start) + " ms");
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        log = Logger.getLogger(AbstractITest.class.getName());
        managementPasword = System.getProperty("hawkular.agent.itest.mgmt.password");
        managementUser = System.getProperty("hawkular.agent.itest.mgmt.user");
        testPasword = System.getProperty("hawkular.itest.rest.password");
        testUser = System.getProperty("hawkular.itest.rest.user");
        tenantId = System.getProperty("hawkular.itest.rest.tenantId");
        waitForAccountsLock = new Object();
        String h = System.getProperty("hawkular.bind.address", "localhost");
        if ("0.0.0.0".equals(h)) {
            h = "localhost";
        }
        hawkularHost = h;
        int hawkularPortOffset = Integer.parseInt(System.getProperty("hawkular.port.offset", "0"));
        hawkularHttpPort = hawkularPortOffset + 8080;
        hawkularManagementPort = hawkularPortOffset + 9990;
        baseInvUri = "http://" + hawkularHost + ":" + hawkularHttpPort + "/hawkular/inventory";
        baseMetricsUri = "http://" + hawkularHost + ":" + hawkularHttpPort + "/hawkular/metrics";
        baseGwUri = "ws://" + hawkularHost + ":" + hawkularHttpPort + "/hawkular/command-gateway";
        authentication = "{\"username\":\"" + testUser + "\",\"password\":\"" + testPasword + "\"}";
        System.out.println("using REST user [" + testUser + "] with password [" + testPasword + "]");
        authHeader = Credentials.basic((String)testUser, (String)testPasword);
        try (ModelControllerClient mcc = AbstractITest.newModelControllerClient(hawkularHost, hawkularManagementPort);){
            hawkularFeedId = DMREndpointService.lookupServerIdentifier((ModelControllerClient)mcc);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get wfFeedId", e);
        }
        String wfHomeProperty = System.getProperty("plain-wildfly.home.dir");
        if (wfHomeProperty != null) {
            wfHome = new File(wfHomeProperty);
            Assert.assertTrue((boolean)wfHome.exists(), (String)("${plain-wildfly.home.dir} [" + wfHome.getAbsolutePath() + "] does not exist"));
        } else {
            wfHome = null;
        }
    }
}

