/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.prometheus.text;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.agent.prometheus.PrometheusMetricDataParser;
import org.hawkular.agent.prometheus.Util;
import org.hawkular.agent.prometheus.text.TextSample;
import org.hawkular.agent.prometheus.types.Counter;
import org.hawkular.agent.prometheus.types.Gauge;
import org.hawkular.agent.prometheus.types.Histogram;
import org.hawkular.agent.prometheus.types.Metric;
import org.hawkular.agent.prometheus.types.MetricFamily;
import org.hawkular.agent.prometheus.types.MetricType;
import org.hawkular.agent.prometheus.types.Summary;
import org.jboss.logging.Logger;

public class TextPrometheusMetricDataParser
extends PrometheusMetricDataParser<MetricFamily> {
    private static final Logger log = Logger.getLogger(TextPrometheusMetricDataParser.class);
    private String lastLineReadFromStream;

    public TextPrometheusMetricDataParser(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public MetricFamily parse() throws IOException {
        String line;
        if (this.lastLineReadFromStream != null) {
            line = this.lastLineReadFromStream;
            this.lastLineReadFromStream = null;
        } else {
            line = this.readLine(this.getInputStream());
        }
        if (line == null) {
            return null;
        }
        if (!line.isEmpty() && !new String(new char[]{line.charAt(0)}).matches("\\p{ASCII}*")) {
            throw new IOException("Doesn't look like the metric data is in text format");
        }
        ParserContext context = new ParserContext();
        while (line != null) {
            line = line.trim();
            try {
                if (!line.isEmpty()) {
                    if (line.charAt(0) == '#') {
                        String[] parts = line.split("[ \t]+", 4);
                        if (parts.length >= 2) {
                            if (parts[1].equals("HELP")) {
                                if (!parts[2].equals(context.name)) {
                                    if (!context.name.isEmpty()) {
                                        this.lastLineReadFromStream = line;
                                        break;
                                    }
                                    context.clear();
                                    context.name = parts[2];
                                    context.type = MetricType.GAUGE;
                                    context.allowedNames.add(parts[2]);
                                }
                                context.help = parts.length == 4 ? this.unescapeHelp(parts[3]) : "";
                            } else if (parts[1].equals("TYPE")) {
                                if (!parts[2].equals(context.name)) {
                                    if (!context.name.isEmpty()) {
                                        this.lastLineReadFromStream = line;
                                        break;
                                    }
                                    context.clear();
                                    context.name = parts[2];
                                }
                                context.type = MetricType.valueOf(parts[3].toUpperCase());
                                context.allowedNames.clear();
                                switch (context.type) {
                                    case COUNTER: {
                                        context.allowedNames.add(context.name);
                                        break;
                                    }
                                    case GAUGE: {
                                        context.allowedNames.add(context.name);
                                        break;
                                    }
                                    case SUMMARY: {
                                        context.allowedNames.add(context.name + "_count");
                                        context.allowedNames.add(context.name + "_sum");
                                        context.allowedNames.add(context.name);
                                        break;
                                    }
                                    case HISTOGRAM: {
                                        context.allowedNames.add(context.name + "_count");
                                        context.allowedNames.add(context.name + "_sum");
                                        context.allowedNames.add(context.name + "_bucket");
                                    }
                                }
                            }
                        }
                    } else {
                        TextSample sample = this.parseSampleLine(line);
                        if (!context.allowedNames.contains(sample.getName())) {
                            if (!context.name.isEmpty()) {
                                this.lastLineReadFromStream = line;
                                break;
                            }
                            context.clear();
                            log.debugf("Ignoring an unexpected metric: " + line, new Object[0]);
                        } else {
                            context.textSamples.add(sample);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.debugf("Failed to process line - it will be ignored: %s", (Object)line);
            }
            line = this.readLine(this.getInputStream());
        }
        if (!context.name.isEmpty()) {
            context.finishMetricFamily();
        }
        return context.finishedMetricFamily;
    }

    private TextSample parseSampleLine(String line) {
        StringBuilder name = new StringBuilder();
        StringBuilder labelname = new StringBuilder();
        StringBuilder labelvalue = new StringBuilder();
        StringBuilder value = new StringBuilder();
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        String state = "name";
        for (int c = 0; c < line.length(); ++c) {
            char charAt = line.charAt(c);
            if (state.equals("name")) {
                if (charAt == '{') {
                    state = "startoflabelname";
                    continue;
                }
                if (charAt == ' ' || charAt == '\t') {
                    state = "endofname";
                    continue;
                }
                name.append(charAt);
                continue;
            }
            if (state.equals("endofname")) {
                if (charAt == ' ' || charAt == '\t') continue;
                if (charAt == '{') {
                    state = "startoflabelname";
                    continue;
                }
                value.append(charAt);
                state = "value";
                continue;
            }
            if (state.equals("startoflabelname")) {
                if (charAt == ' ' || charAt == '\t') continue;
                if (charAt == '}') {
                    state = "endoflabels";
                    continue;
                }
                labelname.append(charAt);
                state = "labelname";
                continue;
            }
            if (state.equals("labelname")) {
                if (charAt == '=') {
                    state = "labelvaluequote";
                    continue;
                }
                if (charAt == '}') {
                    state = "endoflabels";
                    continue;
                }
                if (charAt == ' ' || charAt == '\t') {
                    state = "labelvalueequals";
                    continue;
                }
                labelname.append(charAt);
                continue;
            }
            if (state.equals("labelvalueequals")) {
                if (charAt == '=') {
                    state = "labelvaluequote";
                    continue;
                }
                if (charAt == ' ' || charAt == '\t') continue;
                throw new IllegalStateException("Invalid line: " + line);
            }
            if (state.equals("labelvaluequote")) {
                if (charAt == '\"') {
                    state = "labelvalue";
                    continue;
                }
                if (charAt == ' ' || charAt == '\t') continue;
                throw new IllegalStateException("Invalid line: " + line);
            }
            if (state.equals("labelvalue")) {
                if (charAt == '\\') {
                    state = "labelvalueslash";
                    continue;
                }
                if (charAt == '\"') {
                    labels.put(labelname.toString(), labelvalue.toString());
                    labelname.setLength(0);
                    labelvalue.setLength(0);
                    state = "nextlabel";
                    continue;
                }
                labelvalue.append(charAt);
                continue;
            }
            if (state.equals("labelvalueslash")) {
                state = "labelvalue";
                if (charAt == '\\') {
                    labelvalue.append('\\');
                    continue;
                }
                if (charAt == 'n') {
                    labelvalue.append('\n');
                    continue;
                }
                if (charAt == '\"') {
                    labelvalue.append('\"');
                    continue;
                }
                labelvalue.append('\\').append(charAt);
                continue;
            }
            if (state.equals("nextlabel")) {
                if (charAt == ',') {
                    state = "labelname";
                    continue;
                }
                if (charAt == '}') {
                    state = "endoflabels";
                    continue;
                }
                if (charAt == ' ' || charAt == '\t') continue;
                throw new IllegalStateException("Invalid line: " + line);
            }
            if (state.equals("endoflabels")) {
                if (charAt == ' ' || charAt == '\t') continue;
                value.append(charAt);
                state = "value";
                continue;
            }
            if (!state.equals("value")) continue;
            if (charAt == ' ' || charAt == '\t') break;
            value.append(charAt);
        }
        TextSample sample = ((TextSample.Builder)((TextSample.Builder)new TextSample.Builder().setLine(line).setName(name.toString())).setValue(value.toString()).addLabels(labels)).build();
        return sample;
    }

    private String unescapeHelp(String text) {
        if (text == null || !text.contains("\\")) {
            return text;
        }
        StringBuilder result = new StringBuilder();
        boolean slash = false;
        for (int c = 0; c < text.length(); ++c) {
            char charAt = text.charAt(c);
            if (slash) {
                if (charAt == '\\') {
                    result.append('\\');
                } else if (charAt == 'n') {
                    result.append('\n');
                } else {
                    result.append('\\').append(charAt);
                }
                slash = false;
                continue;
            }
            if (charAt == '\\') {
                slash = true;
                continue;
            }
            result.append(charAt);
        }
        if (slash) {
            result.append("\\");
        }
        return result.toString();
    }

    private String readLine(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int lineChar = inputStream.read();
        while (lineChar != 10 && lineChar != -1) {
            baos.write(lineChar);
            lineChar = inputStream.read();
        }
        if (lineChar == -1 && baos.size() == 0) {
            return null;
        }
        return baos.toString("UTF-8");
    }

    private class ParserContext {
        public MetricFamily finishedMetricFamily;
        public String name = "";
        public String help = "";
        public MetricType type = null;
        public List<String> allowedNames = new ArrayList<String>();
        public List<TextSample> textSamples = new ArrayList<TextSample>();

        private ParserContext() {
        }

        public void clear() {
            this.name = "";
            this.help = "";
            this.type = null;
            this.allowedNames.clear();
            this.textSamples.clear();
        }

        public void finishMetricFamily() {
            if (this.finishedMetricFamily != null) {
                return;
            }
            MetricFamily.Builder metricFamilyBuilder = new MetricFamily.Builder();
            metricFamilyBuilder.setName(this.name);
            metricFamilyBuilder.setHelp(this.help);
            metricFamilyBuilder.setType(this.type);
            LinkedHashMap<Map<String, String>, Object> builders = new LinkedHashMap<Map<String, String>, Object>();
            for (TextSample textSample : this.textSamples) {
                try {
                    switch (this.type) {
                        case COUNTER: {
                            builders.put(textSample.getLabels(), ((Counter.Builder)new Counter.Builder().setName(this.name)).setValue(Util.convertStringToDouble(textSample.getValue())).addLabels(textSample.getLabels()));
                            break;
                        }
                        case GAUGE: {
                            builders.put(textSample.getLabels(), ((Gauge.Builder)new Gauge.Builder().setName(this.name)).setValue(Util.convertStringToDouble(textSample.getValue())).addLabels(textSample.getLabels()));
                            break;
                        }
                        case SUMMARY: {
                            String quantileValue = textSample.getLabels().remove("quantile");
                            Summary.Builder sBuilder = (Summary.Builder)builders.get(textSample.getLabels());
                            if (sBuilder == null) {
                                sBuilder = new Summary.Builder();
                                builders.put(textSample.getLabels(), sBuilder);
                            }
                            sBuilder.setName(this.name);
                            sBuilder.addLabels(textSample.getLabels());
                            if (textSample.getName().endsWith("_count")) {
                                sBuilder.setSampleCount((long)Util.convertStringToDouble(textSample.getValue()));
                                break;
                            }
                            if (textSample.getName().endsWith("_sum")) {
                                sBuilder.setSampleSum(Util.convertStringToDouble(textSample.getValue()));
                                break;
                            }
                            if (quantileValue == null) {
                                log.debugf("Summary quantile sample is missing the 'quantile' label: %s", (Object)textSample.getLine());
                            }
                            sBuilder.addQuantile(Util.convertStringToDouble(quantileValue), Util.convertStringToDouble(textSample.getValue()));
                            break;
                        }
                        case HISTOGRAM: {
                            String bucket = textSample.getLabels().remove("le");
                            Histogram.Builder hBuilder = (Histogram.Builder)builders.get(textSample.getLabels());
                            if (hBuilder == null) {
                                hBuilder = new Histogram.Builder();
                                builders.put(textSample.getLabels(), hBuilder);
                            }
                            hBuilder.setName(this.name);
                            hBuilder.addLabels(textSample.getLabels());
                            if (textSample.getName().endsWith("_count")) {
                                hBuilder.setSampleCount((long)Util.convertStringToDouble(textSample.getValue()));
                                break;
                            }
                            if (textSample.getName().endsWith("_sum")) {
                                hBuilder.setSampleSum(Util.convertStringToDouble(textSample.getValue()));
                                break;
                            }
                            if (bucket == null) {
                                throw new Exception("Histogram bucket sample is missing the 'le' label");
                            }
                            hBuilder.addBucket(Util.convertStringToDouble(bucket), (long)Util.convertStringToDouble(textSample.getValue()));
                        }
                    }
                }
                catch (Exception e) {
                    log.debugf((Throwable)e, "Error processing sample. This metric sample will be ignored: %s", (Object)textSample.getLine());
                }
            }
            for (Metric.Builder builder : builders.values()) {
                try {
                    metricFamilyBuilder.addMetric((Metric)builder.build());
                }
                catch (Exception e) {
                    log.debugf((Throwable)e, "Error building metric for metric family [%s] - it will be ignored", (Object)this.name);
                }
            }
            this.finishedMetricFamily = metricFamilyBuilder.build();
        }
    }
}

