/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.module.installer;

import java.util.ArrayList;
import org.hawkular.wildfly.module.installer.RegisterModuleConfiguration;
import org.hawkular.wildfly.module.installer.XmlConfigBuilder;
import org.hawkular.wildfly.module.installer.XmlEdit;
import org.jboss.logging.Logger;

class RegisterExtension {
    private final Logger log = Logger.getLogger(this.getClass());

    public void register(RegisterModuleConfiguration options) throws Exception {
        switch (options.getConfigType()) {
            case DOMAIN: {
                this.registerToDomain(options);
                break;
            }
            case HOST: {
                this.registerToHost(options);
                break;
            }
            case STANDALONE: {
                this.registerToStandalone(options);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown configuration type: " + (Object)((Object)options.getConfigType()));
            }
        }
        this.log.info((Object)("New serverConfig file written to [" + options.getTargetServerConfig().getAbsolutePath() + "]"));
    }

    private void registerToStandalone(RegisterModuleConfiguration options) throws Exception {
        ArrayList<XmlEdit> inserts = new ArrayList<XmlEdit>();
        inserts.addAll(options.getXmlEdits());
        if (options.getModuleId() != null) {
            this.log.info((Object)("Register STANDALONE extension module=" + options.getModuleId()));
            inserts.add(new XmlEdit("/server/extensions", "<extension module=\"" + options.getModuleId() + "\"/>"));
        }
        if (options.getSubsystem() != null) {
            inserts.add(new XmlEdit("/server/profile", options.getSubsystem()));
        }
        if (options.getSocketBindingGroups() != null && options.getSocketBinding() != null) {
            for (String group : options.getSocketBindingGroups()) {
                inserts.add(new XmlEdit("/server/socket-binding-group[@name='" + group + "']", options.getSocketBinding()).withAttribute("name"));
            }
        }
        new XmlConfigBuilder(options.getSourceServerConfig(), options.getTargetServerConfig()).edits(inserts).failNoMatch(options.isFailNoMatch()).build();
    }

    private void registerToHost(RegisterModuleConfiguration options) throws Exception {
        ArrayList<XmlEdit> inserts = new ArrayList<XmlEdit>();
        inserts.addAll(options.getXmlEdits());
        if (options.getModuleId() != null) {
            this.log.info((Object)("Register HOST extension module=" + options.getModuleId()));
            inserts.add(new XmlEdit("/host/extensions", "<extension module=\"" + options.getModuleId() + "\"/>"));
        }
        if (options.getSubsystem() != null) {
            inserts.add(new XmlEdit("/host/profile", options.getSubsystem()));
        }
        if (options.getSocketBindingGroups() != null && options.getSocketBinding() != null) {
            for (String group : options.getSocketBindingGroups()) {
                inserts.add(new XmlEdit("/host", "<socket-binding-group default-interface=\"public\" name=\"" + group + "\"/>"));
                inserts.add(new XmlEdit("/host/socket-binding-group[@name='" + group + "']", options.getSocketBinding()).withAttribute("name"));
            }
        }
        new XmlConfigBuilder(options.getSourceServerConfig(), options.getTargetServerConfig()).edits(inserts).failNoMatch(options.isFailNoMatch()).build();
    }

    private void registerToDomain(RegisterModuleConfiguration options) throws Exception {
        ArrayList<XmlEdit> inserts = new ArrayList<XmlEdit>();
        inserts.addAll(options.getXmlEdits());
        if (options.getModuleId() != null) {
            this.log.info((Object)("Register DOMAIN extension module=" + options.getModuleId()));
            inserts.add(new XmlEdit("/domain/extensions", "<extension module=\"" + options.getModuleId() + "\"/>"));
        }
        if (options.getSubsystem() != null) {
            for (String profile : options.getProfiles()) {
                inserts.add(new XmlEdit("/domain/profiles/profile[@name='" + profile + "']", options.getSubsystem()));
            }
        }
        if (options.getSocketBindingGroups() != null && options.getSocketBinding() != null) {
            for (String group : options.getSocketBindingGroups()) {
                inserts.add(new XmlEdit("/domain/socket-binding-groups/socket-binding-group[@name='" + group + "']", options.getSocketBinding()).withAttribute("name"));
            }
        }
        new XmlConfigBuilder(options.getSourceServerConfig(), options.getTargetServerConfig()).edits(inserts).failNoMatch(options.isFailNoMatch()).build();
    }
}

